/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.es;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class EmbeddedESStartupServlet
extends HttpServlet {
    private static final Log LOG = ExoLogger.getLogger(EmbeddedESStartupServlet.class);
    protected Node node;

    public void init() throws ServletException {
        LOG.info((Object)("Initializing elasticsearch Node '" + this.getServletName() + "'"));
        ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder();
        InputStream resourceAsStream = this.getServletContext().getResourceAsStream("/WEB-INF/elasticsearch.yml");
        if (resourceAsStream != null) {
            settings.loadFromStream("/WEB-INF/elasticsearch.yml", resourceAsStream);
            try {
                resourceAsStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (settings.get("http.enabled") == null) {
            settings.put("http.enabled", false);
        }
        this.node = NodeBuilder.nodeBuilder().settings((Settings.Builder)settings).node();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void destroy() {
        if (this.node != null) {
            this.node.close();
        }
    }
}

