/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.moxtra.client.MoxtraUser;

public class MoxtraBinder {
    public static final String USER_TYPE_BOARD_OWNER = "BOARD_OWNER";
    public static final String USER_TYPE_BOARD_READ_WRITE = "BOARD_READ_WRITE";
    public static final String USER_STATUS_BOARD_MEMBER = "BOARD_MEMBER";
    public static final String USER_STATUS_BOARD_INVITED = "BOARD_INVITED";
    protected String binderId;
    protected String name;
    protected Long revision;
    protected String thumbnailUrl;
    protected Date createdTime;
    protected Date updatedTime;
    protected List<MoxtraUser> users;
    protected final transient Boolean isNew;
    protected transient boolean deleted;
    private final transient MoxtraBinder original;
    private transient List<MoxtraUser> addedUsers;
    private transient List<MoxtraUser> removedUsers;
    private transient MoxtraBinder editor;

    protected MoxtraBinder(String binderId, String name, Long revision, String thumbnailUrl, Date createdTime, Date updatedTime) {
        this.isNew = Boolean.FALSE;
        this.deleted = false;
        this.binderId = binderId;
        this.name = name;
        this.revision = revision;
        this.thumbnailUrl = thumbnailUrl;
        this.createdTime = createdTime;
        this.updatedTime = updatedTime;
        this.original = null;
    }

    public MoxtraBinder() {
        this.isNew = Boolean.TRUE;
        this.original = null;
    }

    public MoxtraBinder(String binderId, String name, Long revision, Date createdTime, Date updatedTime) {
        this(binderId, name, revision, null, createdTime, updatedTime);
    }

    protected MoxtraBinder(MoxtraBinder other) {
        this.isNew = null;
        this.deleted = false;
        this.original = other;
        this.addedUsers = new ArrayList<MoxtraUser>();
        this.removedUsers = new ArrayList<MoxtraUser>();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        String bid = this.getBinderId();
        if (bid != null) {
            str.append(bid);
        }
        if (str.length() > 0) {
            str.append(' ');
        }
        str.append(this.getName());
        return str.toString();
    }

    public MoxtraBinder editor() {
        if (this.editor != null) {
            return this.editor;
        }
        if (this.isEditor()) {
            return this;
        }
        this.editor = new MoxtraBinder(this);
        return this.editor;
    }

    public boolean isNew() {
        if (this.isEditor()) {
            return this.original.isNew();
        }
        return this.isNew;
    }

    public boolean hasDeleted() {
        if (this.isEditor()) {
            return this.deleted;
        }
        return false;
    }

    public void delete() {
        if (!this.isEditor()) {
            throw new IllegalStateException("Not editor instance");
        }
        this.deleted = true;
    }

    public void undelete() {
        if (!this.isEditor()) {
            throw new IllegalStateException("Not editor instance");
        }
        this.deleted = false;
    }

    public String getBinderId() {
        return this.binderId != null ? this.binderId : (this.isEditor() ? this.original.getBinderId() : null);
    }

    public String getName() {
        return this.name != null ? this.name : (this.isEditor() ? this.original.getName() : null);
    }

    public Long getRevision() {
        return this.revision != null ? this.revision : (this.isEditor() ? this.original.getRevision() : null);
    }

    public String getThumbnailUrl() {
        return this.thumbnailUrl != null ? this.thumbnailUrl : (this.isEditor() ? this.original.getThumbnailUrl() : null);
    }

    public Date getCreatedTime() {
        return this.createdTime != null ? this.createdTime : (this.isEditor() ? this.original.getCreatedTime() : null);
    }

    public Date getUpdatedTime() {
        return this.updatedTime != null ? this.updatedTime : (this.isEditor() ? this.original.getUpdatedTime() : null);
    }

    public synchronized void addUser(MoxtraUser user) {
        if (this.isEditor()) {
            for (MoxtraUser added : this.addedUsers) {
                if (!added.equals(user)) continue;
                return;
            }
            List<MoxtraUser> origUsers = this.original.getUsers();
            if (origUsers != null) {
                for (MoxtraUser existing : origUsers) {
                    if (!existing.equals(user)) continue;
                    return;
                }
            }
            Iterator<MoxtraUser> riter = this.removedUsers.iterator();
            while (riter.hasNext()) {
                MoxtraUser removed = riter.next();
                if (!removed.equals(user)) continue;
                riter.remove();
            }
        } else {
            throw new IllegalStateException("Not editor instance");
        }
        this.addedUsers.add(user);
    }

    public synchronized void removeUser(MoxtraUser user) {
        if (this.isEditor()) {
            for (MoxtraUser removed : this.removedUsers) {
                if (!removed.equals(user)) continue;
                return;
            }
            Iterator<MoxtraUser> aiter = this.addedUsers.iterator();
            while (aiter.hasNext()) {
                MoxtraUser added = aiter.next();
                if (!added.equals(user)) continue;
                aiter.remove();
            }
        } else {
            throw new IllegalStateException("Not editor instance");
        }
        this.removedUsers.add(user);
    }

    public synchronized List<MoxtraUser> getUsers() {
        if (this.isEditor()) {
            List<MoxtraUser> origUsers = this.original.getUsers();
            if (this.removedUsers != null) {
                ArrayList<MoxtraUser> res = new ArrayList<MoxtraUser>();
                if (origUsers != null) {
                    block0: for (MoxtraUser existing : origUsers) {
                        for (MoxtraUser removed : this.removedUsers) {
                            if (!existing.equals(removed)) continue;
                            continue block0;
                        }
                        res.add(existing);
                    }
                }
                if (this.addedUsers != null) {
                    res.addAll(this.addedUsers);
                }
                return res;
            }
            if (this.addedUsers != null) {
                ArrayList<MoxtraUser> res = new ArrayList<MoxtraUser>();
                if (origUsers != null) {
                    res.addAll(origUsers);
                }
                res.addAll(this.addedUsers);
                return res;
            }
            return origUsers;
        }
        return this.users;
    }

    public List<MoxtraUser> getAddedUsers() {
        if (this.isEditor()) {
            return Collections.unmodifiableList(this.addedUsers);
        }
        return null;
    }

    public boolean hasUsersAdded() {
        if (this.isEditor()) {
            return this.addedUsers.size() > 0;
        }
        return false;
    }

    public List<MoxtraUser> getRemovedUsers() {
        if (this.isEditor()) {
            return Collections.unmodifiableList(this.removedUsers);
        }
        return null;
    }

    public boolean hasUsersRemoved() {
        if (this.isEditor()) {
            return this.removedUsers.size() > 0;
        }
        return false;
    }

    public void editName(String newName) {
        if (!this.isEditor()) {
            throw new IllegalStateException("Not editor instance");
        }
        this.name = newName;
    }

    public boolean hasNameChanged() {
        if (this.isEditor() && this.name != null) {
            return !this.name.equals(this.original.getName());
        }
        return false;
    }

    public boolean isEditor() {
        return this.original != null;
    }

    protected void setUsers(List<MoxtraUser> users) {
        if (this.isEditor()) {
            this.original.setUsers(users);
            this.users = null;
            this.deleted = false;
            this.addedUsers.clear();
            this.removedUsers.clear();
        } else {
            this.users = users;
        }
    }

    protected void setBinderId(String binderId) {
        if (this.isEditor()) {
            this.original.setBinderId(binderId);
            this.binderId = null;
            this.deleted = false;
        } else {
            this.binderId = binderId;
        }
    }

    protected void setName(String name) {
        if (this.isEditor()) {
            this.original.setName(name);
            this.name = null;
            this.deleted = false;
        } else {
            this.name = name;
        }
    }

    protected void setRevision(Long revision) {
        if (this.isEditor()) {
            this.original.setRevision(revision);
            this.revision = null;
            this.deleted = false;
        } else {
            this.revision = revision;
        }
    }

    protected void setThumbnailUrl(String url) {
        if (this.isEditor()) {
            this.original.setThumbnailUrl(url);
            this.deleted = false;
        } else {
            this.thumbnailUrl = url;
        }
    }

    protected void setCreatedTime(Date createdTime) {
        if (this.isEditor()) {
            this.original.setCreatedTime(createdTime);
            this.deleted = false;
        } else {
            this.createdTime = createdTime;
        }
    }

    protected void setUpdatedTime(Date updatedTime) {
        if (this.isEditor()) {
            this.original.setUpdatedTime(updatedTime);
            this.deleted = false;
        } else {
            this.updatedTime = updatedTime;
        }
    }
}

