/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra.rest;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.moxtra.MoxtraService;
import org.exoplatform.moxtra.client.MoxtraClient;
import org.exoplatform.moxtra.rest.ErrorInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/moxtra/user")
@Produces(value={"application/json"})
public class UserService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(UserService.class);
    protected final MoxtraService moxtra;
    protected final OrganizationService orgService;

    public UserService(MoxtraService moxtra, OrganizationService orgService) {
        this.moxtra = moxtra;
        this.orgService = orgService;
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/exo/{userName}")
    public Response getLocalUser(@Context UriInfo uriInfo, @PathParam(value="userName") String userName) {
        try {
            User exoUser = this.orgService.getUserHandler().findUserByName(userName);
            if (exoUser != null) {
                return Response.ok().entity((Object)new UserInfo(exoUser.getUserName(), exoUser.getFirstName(), exoUser.getLastName(), exoUser.getEmail())).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorInfo.notFoundError("User not found " + userName)).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error reading user " + userName), (Throwable)e);
            return Response.serverError().entity((Object)ErrorInfo.serverError("Error reading user")).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/me")
    public Response getMoxtraCurrentUserAuth() {
        try {
            String userName = ConversationState.getCurrent().getIdentity().getUserId();
            MoxtraClient client = this.moxtra.getClient();
            boolean authorized = client.isAuthorized();
            String authLink = !authorized ? client.authorizer().authorizationLink() : null;
            return Response.ok().entity((Object)new AuthInfo(userName, authorized, authLink)).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting authorization info", (Throwable)e);
            return Response.serverError().entity((Object)ErrorInfo.serverError("Error getting authorization link")).build();
        }
    }

    protected class AuthInfo {
        final String userName;
        final boolean authorized;
        final String authLink;

        protected AuthInfo(String userId, boolean authorized, String authLink) {
            this.userName = userId;
            this.authorized = authorized;
            this.authLink = authLink;
        }

        public boolean isAuthorized() {
            return this.authorized;
        }

        public String getAuthLink() {
            return this.authLink;
        }

        public String getUserName() {
            return this.userName;
        }
    }

    protected class UserInfo {
        final String userName;
        final String firstName;
        final String lastName;
        final String email;

        protected UserInfo(String userName, String firstName, String lastName, String email) {
            this.userName = userName;
            this.firstName = firstName;
            this.lastName = lastName;
            this.email = email;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public String getEmail() {
            return this.email;
        }
    }
}

