/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra.webui;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.moxtra.webui.MoxtraApplication;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.core.UIApplication;

public class MoxtraApplicationActivator
extends BaseComponentPlugin {
    public static final String CONF_APP_TYPE = "app-type";
    public static final String CONF_COMPONENT_TYPE = "component-type";
    public static final String CONF_COMPONENT_ID = "component-id";
    protected static final Log LOG = ExoLogger.getLogger(MoxtraApplicationActivator.class);
    protected final Map<String, String> config;
    protected final Map<UIApplication, MoxtraApplication> apps = new WeakHashMap<UIApplication, MoxtraApplication>();

    public MoxtraApplicationActivator(InitParams params) throws ConfigurationException {
        PropertiesParam param = params.getPropertiesParam("app-configuration");
        if (param == null) {
            throw new ConfigurationException("Property parameters app-configuration required.");
        }
        this.config = Collections.unmodifiableMap(param.getProperties());
    }

    public String getAppType() {
        return this.config.get(CONF_APP_TYPE);
    }

    public String getComponentType() {
        return this.config.get(CONF_COMPONENT_TYPE);
    }

    public String getComponentId() {
        return this.config.get(CONF_COMPONENT_ID);
    }

    public boolean isCompatible(UIApplication uiApp) {
        String compId = this.getComponentId();
        boolean res = compId == null || compId.equals(uiApp.getId());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("> isCompatible:" + res + " " + uiApp));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(UIApplication uiApp) {
        MoxtraApplication app = this.apps.get(uiApp);
        if (app == null) {
            UIApplication uIApplication = uiApp;
            synchronized (uIApplication) {
                app = this.apps.get(uiApp);
                if (app == null) {
                    try {
                        String appType = this.getAppType();
                        Class<?> appClass = Class.forName(appType);
                        if (MoxtraApplication.class.isAssignableFrom(appClass)) {
                            try {
                                app = (MoxtraApplication)appClass.newInstance();
                                app.init();
                                this.apps.put(uiApp, app);
                            }
                            catch (SecurityException e) {
                                LOG.error((Object)("Cannot load app constructor for " + appType), (Throwable)e);
                            }
                            catch (InstantiationException e) {
                                LOG.error((Object)("Cannot instantiate app " + appType), (Throwable)e);
                            }
                            catch (IllegalAccessException e) {
                                LOG.error((Object)("Cannot access app constructor for " + appType), (Throwable)e);
                            }
                            catch (IllegalArgumentException e) {
                                LOG.error((Object)("App constructor has wrong arguments in " + appType), (Throwable)e);
                            }
                        } else {
                            LOG.error((Object)("Given app type is not an instance of " + MoxtraApplication.class.getName() + " and cannot be used within " + uiApp));
                        }
                    }
                    catch (ClassNotFoundException e) {
                        LOG.error((Object)("Error activating Moxtra app for " + uiApp), (Throwable)e);
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("> activate: " + uiApp + " = " + app));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("> reactivate: " + uiApp + " = " + app));
        }
        if (app != null) {
            app.activate(uiApp);
        } else {
            LOG.warn((Object)("Moxtra app not found or cannot be initialized for " + uiApp));
        }
    }

    public void deactivate(UIApplication uiApp) {
        MoxtraApplication app = this.apps.get(uiApp);
        if (app != null) {
            app.deactivate(uiApp);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("> deactivate: " + uiApp + " = " + app));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoxtraApplication getApplication(UIApplication uiApp) {
        UIApplication uIApplication = uiApp;
        synchronized (uIApplication) {
            return this.apps.get(uiApp);
        }
    }
}

