/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.jcr.Node;

public class Config
implements Externalizable {
    protected static final SimpleDateFormat DATETIME_FORMAT = new SimpleDateFormat("MM/dd/yyyy");
    protected static final String NO_LANG = "no_lang".intern();
    protected static final String EMPTY = "".intern();
    private String documentserverUrl;
    private String documentserverJsUrl;
    private String platformUrl;
    private String workspace;
    private String path;
    private String documentType;
    private Document document;
    private Editor editorConfig;
    private String error;
    private transient Node node;
    protected Boolean open;

    protected static Builder editor(String documentserverUrl, String workspace, String path, String documentType) {
        return new Builder(documentserverUrl, documentType, workspace, path);
    }

    protected static String fileUrl(String platformUrl, String userId, String key) {
        return platformUrl + "/content/" + userId + "/" + key;
    }

    protected static String callbackUrl(String platformUrl, String userId, String key) {
        return platformUrl + "/status/" + userId + "/" + key;
    }

    public Config() {
    }

    protected Config(String documentserverUrl, String platformUrl, String workspace, String path, String documentType, Document document, Editor editor) {
        this.workspace = workspace;
        this.path = path;
        this.documentType = documentType;
        this.documentserverUrl = documentserverUrl;
        this.documentserverJsUrl = documentserverUrl + "apps/api/documents/api.js";
        this.platformUrl = platformUrl;
        this.document = document;
        this.editorConfig = editor;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.workspace);
        out.writeUTF(this.path);
        out.writeUTF(this.documentType);
        out.writeUTF(this.documentserverUrl);
        out.writeUTF(this.documentserverJsUrl);
        out.writeUTF(this.platformUrl);
        out.writeUTF(this.open != null ? this.open.toString() : EMPTY);
        out.writeUTF(this.error != null ? this.error : EMPTY);
        out.writeUTF(this.document.getKey());
        out.writeUTF(this.document.getFileType());
        out.writeUTF(this.document.getTitle());
        out.writeUTF(this.document.getUrl());
        out.writeUTF(this.document.getInfo().getAuthor());
        out.writeUTF(this.document.getInfo().getCreated());
        out.writeUTF(this.document.getInfo().getFolder());
        out.writeUTF(this.editorConfig.getCallbackUrl());
        String elang = this.editorConfig.getLang();
        out.writeUTF(elang != null ? elang : NO_LANG);
        out.writeUTF(this.editorConfig.getMode());
        out.writeUTF(this.editorConfig.getUser().getId());
        out.writeUTF(this.editorConfig.getUser().getFirstname());
        out.writeUTF(this.editorConfig.getUser().getLastname());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.workspace = in.readUTF();
        this.path = in.readUTF();
        this.documentType = in.readUTF();
        this.documentserverUrl = in.readUTF();
        this.documentserverJsUrl = in.readUTF();
        this.platformUrl = in.readUTF();
        String openString = in.readUTF();
        this.open = EMPTY.equals(openString) ? null : Boolean.valueOf(openString);
        String errorString = in.readUTF();
        this.error = EMPTY.equals(errorString) ? null : errorString;
        String dkey = in.readUTF();
        String dfileType = in.readUTF();
        String dtitle = in.readUTF();
        String durl = in.readUTF();
        String diauthor = in.readUTF();
        String dicreated = in.readUTF();
        String difolder = in.readUTF();
        Document.Info dinfo = new Document.Info(diauthor, dicreated, difolder);
        this.document = new Document(dkey, dfileType, dtitle, durl, dinfo, new Document.EditPermissions());
        String ecallbackUrl = in.readUTF();
        String elang = in.readUTF();
        if (NO_LANG.equals(elang)) {
            elang = null;
        }
        String emode = in.readUTF();
        String euid = in.readUTF();
        String eufirstname = in.readUTF();
        String eulastname = in.readUTF();
        Editor.User euser = new Editor.User(euid, eufirstname, eulastname);
        this.editorConfig = new Editor(ecallbackUrl, elang, emode, euser);
    }

    public String getDocumentserverJsUrl() {
        return this.documentserverJsUrl;
    }

    public String getDocumentserverUrl() {
        return this.documentserverUrl;
    }

    public Node getContextNode() {
        return this.node;
    }

    protected void setContextNode(Node node) {
        this.node = node;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public String getPath() {
        return this.path;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public Document getDocument() {
        return this.document;
    }

    public Editor getEditorConfig() {
        return this.editorConfig;
    }

    public Config forUser(String id, String firstName, String lastName, String lang) {
        return new Config(this.documentserverUrl, this.platformUrl, this.workspace, this.path, this.documentType, this.document.forUser(id, firstName, lastName, Config.fileUrl(this.platformUrl, id, this.document.getKey())), this.editorConfig.forUser(id, firstName, lastName, lang, Config.callbackUrl(this.platformUrl, id, this.document.getKey())));
    }

    public boolean isCreated() {
        return this.open == null;
    }

    public boolean isOpen() {
        return this.open != null ? this.open : false;
    }

    public boolean isClosed() {
        return this.open != null ? !this.open.booleanValue() : false;
    }

    public void open() {
        this.open = new Boolean(true);
    }

    public void close() {
        this.open = new Boolean(false);
    }

    public void setError(String error) {
        this.error = error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public String getError() {
        return this.error;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Config) {
            Config other = (Config)obj;
            return this.documentType.equals(other.documentType) && this.workspace.equals(other.workspace) && this.path.equals(other.path);
        }
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.documentType);
        s.append(' ');
        s.append(this.workspace);
        s.append(':');
        s.append(this.path);
        if (this.open != null) {
            s.append(" (");
            s.append(this.open != false ? "open" : "closed");
            s.append(')');
        }
        return s.toString();
    }

    public static class Editor {
        protected final String callbackUrl;
        protected final String mode;
        protected final User user;
        protected String lang;

        protected Editor(String callbackUrl, String lang, String mode, User user) {
            this.callbackUrl = callbackUrl;
            this.lang = lang;
            this.mode = mode;
            this.user = user;
        }

        public String getCallbackUrl() {
            return this.callbackUrl;
        }

        public String getLang() {
            return this.lang;
        }

        public void setLang(String lang) {
            this.lang = lang;
        }

        public String getMode() {
            return this.mode;
        }

        public User getUser() {
            return this.user;
        }

        protected Editor forUser(String id, String firstName, String lastName, String lang, String callbackUrl) {
            User otherUser = new User(id, firstName, lastName);
            return new Editor(callbackUrl, lang, this.mode, otherUser);
        }

        public static class User {
            protected final String id;
            protected final String firstname;
            protected final String lastname;
            protected final String username;
            protected transient String lockToken;

            protected User(String id, String firstname, String lastname) {
                this.id = id;
                this.username = id;
                this.firstname = firstname;
                this.lastname = lastname;
            }

            public String getId() {
                return this.id;
            }

            public String getUsername() {
                return this.username;
            }

            public String getFirstname() {
                return this.firstname;
            }

            public String getLastname() {
                return this.lastname;
            }

            protected String getLockToken() {
                return this.lockToken;
            }

            protected void setLockToken(String lockToken) {
                this.lockToken = lockToken;
            }
        }
    }

    public static class Document {
        protected final String fileType;
        protected final String key;
        protected final String title;
        protected final String url;
        protected final Info info;
        protected final Permissions permissions;

        protected Document(String key, String fileType, String title, String url, Info info, Permissions permissions) {
            this.fileType = fileType;
            this.key = key;
            this.title = title;
            this.url = url;
            this.info = info;
            this.permissions = permissions;
        }

        protected Document forUser(String id, String firstName, String lastName, String url) {
            return new Document(this.key, this.fileType, this.title, url, this.info, this.permissions);
        }

        public String getFileType() {
            return this.fileType;
        }

        public String getKey() {
            return this.key;
        }

        public String getTitle() {
            return this.title;
        }

        public String getUrl() {
            return this.url;
        }

        public Info getInfo() {
            return this.info;
        }

        public Permissions getPermissions() {
            return this.permissions;
        }

        public static class EditPermissions
        extends Permissions {
            protected EditPermissions() {
                super(true, true);
            }
        }

        public static abstract class Permissions {
            protected final boolean download;
            protected final boolean edit;

            protected Permissions(boolean download, boolean edit) {
                this.download = download;
                this.edit = edit;
            }

            public boolean isDownload() {
                return this.download;
            }

            public boolean isEdit() {
                return this.edit;
            }
        }

        public static class Info {
            protected final String author;
            protected final String created;
            protected final String folder;

            protected Info(String author, String created, String folder) {
                this.author = author;
                this.created = created;
                this.folder = folder;
            }

            public String getAuthor() {
                return this.author;
            }

            public String getCreated() {
                return this.created;
            }

            public String getFolder() {
                return this.folder;
            }
        }
    }

    public static class Builder {
        protected final String workspace;
        protected final String path;
        protected final String documentType;
        protected final String documentserverUrl;
        protected String platformUrl;
        protected String fileType;
        protected String key;
        protected String title;
        protected String url;
        protected String author;
        protected String created;
        protected String folder;
        protected String callbackUrl;
        protected String lang;
        protected String mode;
        protected String userId;
        protected String firstname;
        protected String lastname;

        protected Builder(String documentserverUrl, String documentType, String workspace, String path) {
            this.documentserverUrl = documentserverUrl;
            this.documentType = documentType;
            this.workspace = workspace;
            this.path = path;
        }

        public Builder generateUrls(String platformUrl) {
            this.platformUrl = platformUrl;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder fileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder author(String author) {
            this.author = author;
            return this;
        }

        public Builder created(Calendar createdTime) {
            this.created = DATETIME_FORMAT.format(createdTime.getTime());
            return this;
        }

        public Builder folder(String folder) {
            this.folder = folder;
            return this;
        }

        public Builder callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        public Builder lang(String lang) {
            this.lang = lang;
            return this;
        }

        public Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder userFirstName(String firstname) {
            this.firstname = firstname;
            return this;
        }

        public Builder userLastName(String lastname) {
            this.lastname = lastname;
            return this;
        }

        public Config build() {
            if (this.platformUrl != null) {
                this.url = this.platformUrl + "/content/" + this.userId + "/" + this.key;
                this.callbackUrl = this.platformUrl + "/status/" + this.userId + "/" + this.key;
            }
            Document.Info info = new Document.Info(this.author, this.created, this.folder);
            Document.EditPermissions permissions = new Document.EditPermissions();
            Document document = new Document(this.key, this.fileType, this.title, this.url, info, permissions);
            Editor.User user = new Editor.User(this.userId, this.firstname, this.lastname);
            Editor editor = new Editor(this.callbackUrl, this.lang, this.mode, user);
            return new Config(this.documentserverUrl, this.platformUrl, this.workspace, this.path, this.documentType, document, editor);
        }
    }
}

