/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.webui;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.exoplatform.onlyoffice.OnlyofficeEditorException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.application.WebuiRequestContext;

public class OnlyofficeEditorContext {
    protected static final String JAVASCRIPT = "OnlyofficeEditorContext_Javascript".intern();
    protected static final Log LOG = ExoLogger.getLogger(OnlyofficeEditorContext.class);
    private static final ThreadLocal<Map<String, String>> messages = new ThreadLocal();
    private final RequireJS require;

    public static void init(RequestContext requestContext, String workspace, String nodePath) throws OnlyofficeEditorException {
        Object obj = requestContext.getAttribute(JAVASCRIPT);
        if (obj == null) {
            OnlyofficeEditorContext context = new OnlyofficeEditorContext(requestContext);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Init Onlyoffice editor for " + workspace + ":" + nodePath));
            }
            context.init(workspace, nodePath);
            requestContext.setAttribute(JAVASCRIPT, (Object)context);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Request context already initialized");
        }
    }

    public static void open(RequestContext requestContext) throws OnlyofficeEditorException {
        Object obj = requestContext.getAttribute(JAVASCRIPT);
        if (obj != null) {
            OnlyofficeEditorContext context = (OnlyofficeEditorContext)obj;
            context.open();
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Request context not initialized");
        }
    }

    public static void show(RequestContext requestContext) throws OnlyofficeEditorException {
        Object obj = requestContext.getAttribute(JAVASCRIPT);
        if (obj != null) {
            OnlyofficeEditorContext context = (OnlyofficeEditorContext)obj;
            context.show();
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Request context not initialized");
        }
    }

    public static void close(RequestContext requestContext) throws OnlyofficeEditorException {
        Object obj = requestContext.getAttribute(JAVASCRIPT);
        if (obj != null) {
            OnlyofficeEditorContext context = (OnlyofficeEditorContext)obj;
            context.close();
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Request context not initialized");
        }
    }

    public static void showInfo(RequestContext requestContext, String title, String message) throws RepositoryException, OnlyofficeEditorException {
        Object obj = requestContext.getAttribute(JAVASCRIPT);
        if (obj != null) {
            OnlyofficeEditorContext context = (OnlyofficeEditorContext)obj;
            context.showInfo(title, message);
        } else {
            Map<String, String> contextMessages;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Context not initialized. Adding info message to local cache.");
            }
            if ((contextMessages = messages.get()) == null) {
                contextMessages = new LinkedHashMap<String, String>();
                messages.set(contextMessages);
            }
            contextMessages.put(title, message);
        }
    }

    private OnlyofficeEditorContext(RequestContext requestContext) {
        JavascriptManager jsMan = ((WebuiRequestContext)requestContext).getJavascriptManager();
        this.require = jsMan.require("SHARED/onlyoffice", "onlyoffice");
    }

    private OnlyofficeEditorContext init(String workspace, String nodePath) {
        this.require.addScripts("onlyoffice.init('" + workspace + "','" + nodePath + "');");
        return this;
    }

    private OnlyofficeEditorContext open() {
        this.require.addScripts("onlyoffice.open();");
        return this;
    }

    private OnlyofficeEditorContext show() {
        this.require.addScripts("onlyoffice.show();");
        return this;
    }

    private OnlyofficeEditorContext close() {
        this.require.addScripts("onlyoffice.close();");
        return this;
    }

    private OnlyofficeEditorContext showInfo(String title, String text) {
        return this;
    }
}

