/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.jcr.Node;

public class Config {
    protected static final SimpleDateFormat DATETIME_FORMAT = new SimpleDateFormat("MM/dd/yyyy");
    protected final String documentserverUrl;
    protected final String documentserverJsUrl;
    protected final String platformUrl;
    protected final String workspace;
    protected final String path;
    protected final String documentType;
    protected final Document document;
    protected final Editor editorConfig;
    protected String error;
    protected transient Node node;
    protected transient Boolean open;

    protected static Builder editor(String documentserverUrl, String workspace, String path, String documentType) {
        return new Builder(documentserverUrl, documentType, workspace, path);
    }

    protected static String fileUrl(String platformUrl, String userId, String key) {
        return platformUrl + "/content/" + userId + "/" + key;
    }

    protected static String callbackUrl(String platformUrl, String userId, String key) {
        return platformUrl + "/status/" + userId + "/" + key;
    }

    protected Config(String documentserverUrl, String platformUrl, String workspace, String path, String documentType, Document document, Editor editor) {
        this.workspace = workspace;
        this.path = path;
        this.documentType = documentType;
        this.documentserverUrl = documentserverUrl;
        this.documentserverJsUrl = documentserverUrl + "apps/api/documents/api.js";
        this.platformUrl = platformUrl;
        this.document = document;
        this.editorConfig = editor;
    }

    public String getDocumentserverJsUrl() {
        return this.documentserverJsUrl;
    }

    public String getDocumentserverUrl() {
        return this.documentserverUrl;
    }

    public Node getContextNode() {
        return this.node;
    }

    protected void setContextNode(Node node) {
        this.node = node;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public String getPath() {
        return this.path;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public Document getDocument() {
        return this.document;
    }

    public Editor getEditorConfig() {
        return this.editorConfig;
    }

    public Config forUser(String id, String firstName, String lastName, String lang) {
        return new Config(this.documentserverUrl, this.platformUrl, this.workspace, this.path, this.documentType, this.document.forUser(id, firstName, lastName, Config.fileUrl(this.platformUrl, id, this.document.getKey())), this.editorConfig.forUser(id, firstName, lastName, lang, Config.callbackUrl(this.platformUrl, id, this.document.getKey())));
    }

    public boolean isCreated() {
        return this.open == null;
    }

    public boolean isOpen() {
        return this.open != null ? this.open : false;
    }

    public boolean isClosed() {
        return this.open != null ? !this.open.booleanValue() : false;
    }

    public void open() {
        this.open = new Boolean(true);
    }

    public void close() {
        this.open = new Boolean(false);
    }

    public void setError(String error) {
        this.error = error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public String getError() {
        return this.error;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Config) {
            Config other = (Config)obj;
            return this.documentType.equals(other.documentType) && this.workspace.equals(other.workspace) && this.path.equals(other.path);
        }
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.documentType);
        s.append(' ');
        s.append(this.workspace);
        s.append(':');
        s.append(this.path);
        return s.toString();
    }

    public static class Editor {
        protected final String callbackUrl;
        protected final String lang;
        protected final String mode;
        protected final User user;

        protected Editor(String callbackUrl, String lang, String mode, User user) {
            this.callbackUrl = callbackUrl;
            this.lang = lang;
            this.mode = mode;
            this.user = user;
        }

        public String getCallbackUrl() {
            return this.callbackUrl;
        }

        public String getLang() {
            return this.lang;
        }

        public String getMode() {
            return this.mode;
        }

        public User getUser() {
            return this.user;
        }

        protected Editor forUser(String id, String firstName, String lastName, String lang, String callbackUrl) {
            User otherUser = new User(id, firstName, lastName);
            return new Editor(callbackUrl, lang, this.mode, otherUser);
        }

        public static class User {
            protected final String id;
            protected final String firstname;
            protected final String lastname;
            protected final String username;
            protected transient String lockToken;

            protected User(String id, String firstname, String lastname) {
                this.id = id;
                this.username = id;
                this.firstname = firstname;
                this.lastname = lastname;
            }

            public String getId() {
                return this.id;
            }

            public String getUsername() {
                return this.username;
            }

            public String getFirstname() {
                return this.firstname;
            }

            public String getLastname() {
                return this.lastname;
            }

            protected String getLockToken() {
                return this.lockToken;
            }

            protected void setLockToken(String lockToken) {
                this.lockToken = lockToken;
            }
        }
    }

    public static class Document {
        protected final String fileType;
        protected final String key;
        protected final String title;
        protected final String url;
        protected final Info info;
        protected final Permissions permissions;

        protected Document(String key, String fileType, String title, String url, Info info, Permissions permissions) {
            this.fileType = fileType;
            this.key = key;
            this.title = title;
            this.url = url;
            this.info = info;
            this.permissions = permissions;
        }

        protected Document forUser(String id, String firstName, String lastName, String url) {
            return new Document(this.key, this.fileType, this.title, url, this.info, this.permissions);
        }

        public String getFileType() {
            return this.fileType;
        }

        public String getKey() {
            return this.key;
        }

        public String getTitle() {
            return this.title;
        }

        public String getUrl() {
            return this.url;
        }

        public Info getInfo() {
            return this.info;
        }

        public Permissions getPermissions() {
            return this.permissions;
        }

        public static class EditPermissions
        extends Permissions {
            protected EditPermissions() {
                super(true, true);
            }
        }

        public static abstract class Permissions {
            protected final boolean download;
            protected final boolean edit;

            protected Permissions(boolean download, boolean edit) {
                this.download = download;
                this.edit = edit;
            }

            public boolean isDownload() {
                return this.download;
            }

            public boolean isEdit() {
                return this.edit;
            }
        }

        public static class Info {
            protected final String author;
            protected final String created;
            protected final String folder;

            protected Info(String author, String created, String folder) {
                this.author = author;
                this.created = created;
                this.folder = folder;
            }

            public String getAuthor() {
                return this.author;
            }

            public String getCreated() {
                return this.created;
            }

            public String getFolder() {
                return this.folder;
            }
        }
    }

    public static class Builder {
        protected final String workspace;
        protected final String path;
        protected final String documentType;
        protected final String documentserverUrl;
        protected String platformUrl;
        protected String fileType;
        protected String key;
        protected String title;
        protected String url;
        protected String author;
        protected String created;
        protected String folder;
        protected String callbackUrl;
        protected String lang;
        protected String mode;
        protected String userId;
        protected String firstname;
        protected String lastname;

        protected Builder(String documentserverUrl, String documentType, String workspace, String path) {
            this.documentserverUrl = documentserverUrl;
            this.documentType = documentType;
            this.workspace = workspace;
            this.path = path;
        }

        public Builder generateUrls(String platformUrl) {
            this.platformUrl = platformUrl;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder fileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder author(String author) {
            this.author = author;
            return this;
        }

        public Builder created(Calendar createdTime) {
            this.created = DATETIME_FORMAT.format(createdTime.getTime());
            return this;
        }

        public Builder folder(String folder) {
            this.folder = folder;
            return this;
        }

        public Builder callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        public Builder lang(String lang) {
            this.lang = lang;
            return this;
        }

        public Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder userFirstName(String firstname) {
            this.firstname = firstname;
            return this;
        }

        public Builder userLastName(String lastname) {
            this.lastname = lastname;
            return this;
        }

        public Config build() {
            if (this.platformUrl != null) {
                this.url = this.platformUrl + "/content/" + this.userId + "/" + this.key;
                this.callbackUrl = this.platformUrl + "/status/" + this.userId + "/" + this.key;
            }
            Document.Info info = new Document.Info(this.author, this.created, this.folder);
            Document.EditPermissions permissions = new Document.EditPermissions();
            Document document = new Document(this.key, this.fileType, this.title, this.url, info, permissions);
            Editor.User user = new Editor.User(this.userId, this.firstname, this.lastname);
            Editor editor = new Editor(this.callbackUrl, this.lang, this.mode, user);
            return new Config(this.documentserverUrl, this.platformUrl, this.workspace, this.path, this.documentType, document, editor);
        }
    }
}

