/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.webui;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;
import org.exoplatform.onlyoffice.Config;
import org.exoplatform.onlyoffice.OnlyofficeEditorListener;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheListenerContext;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class OnlyofficeEditorUIService {
    public static final String CACHE_NAME = "onlyoffice.EditorStateCache".intern();
    protected static final Log LOG = ExoLogger.getLogger(OnlyofficeEditorUIService.class);
    public static final String STATE_OPENING = "opening".intern();
    public static final String STATE_OPEN = "open".intern();
    public static final String STATE_CLOSING = "closing".intern();
    protected final ExoCache<String, String> editorsCache;
    protected final ReentrantLock editorsLock = new ReentrantLock();
    protected final OnlyofficeEditorService editorService;

    public OnlyofficeEditorUIService(OnlyofficeEditorService editorService, CacheService cacheService) {
        this.editorService = editorService;
        this.editorsCache = cacheService.getCacheInstance(CACHE_NAME);
        if (LOG.isDebugEnabled()) {
            this.editorsCache.addCacheListener((CacheListener)new CacheListener<String, String>(){

                public void onExpire(CacheListenerContext context, String key, String obj) throws Exception {
                    LOG.debug((Object)(CACHE_NAME + " onExpire > " + key + ": " + obj));
                }

                public void onRemove(CacheListenerContext context, String key, String obj) throws Exception {
                    LOG.debug((Object)(CACHE_NAME + " onRemove > " + key + ": " + obj));
                }

                public void onPut(CacheListenerContext context, String key, String obj) throws Exception {
                    LOG.debug((Object)(CACHE_NAME + " onPut > " + key + ": " + obj));
                }

                public void onGet(CacheListenerContext context, String key, String obj) throws Exception {
                    LOG.debug((Object)(CACHE_NAME + " onGet > " + key + ": " + obj));
                }

                public void onClearCache(CacheListenerContext context) throws Exception {
                    LOG.debug((Object)(CACHE_NAME + " onClearCache"));
                }
            });
        }
        editorService.addListener(new EditorListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        String state = (String)this.editorsCache.get((Serializable)((Object)id));
        if (state == null) {
            this.editorsLock.lock();
            try {
                state = (String)this.editorsCache.get((Serializable)((Object)id));
                if (state == null) {
                    this.editorsCache.put((Serializable)((Object)id), (Object)STATE_OPENING);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.editorsLock.unlock();
            }
        }
        return STATE_OPENING.equals(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean opened(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        String state = (String)this.editorsCache.get((Serializable)((Object)id));
        if (STATE_OPENING.equals(state)) {
            this.editorsLock.lock();
            try {
                this.editorsCache.put((Serializable)((Object)id), (Object)STATE_OPEN);
                boolean bl = true;
                return bl;
            }
            finally {
                this.editorsLock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        String state = (String)this.editorsCache.get((Serializable)((Object)id));
        if (STATE_OPEN.equals(state)) {
            this.editorsLock.lock();
            try {
                this.editorsCache.put((Serializable)((Object)id), (Object)STATE_CLOSING);
                boolean bl = true;
                return bl;
            }
            finally {
                this.editorsLock.unlock();
            }
        }
        if (STATE_OPENING.equals(state)) {
            this.editorsLock.lock();
            try {
                boolean bl = STATE_OPENING.equals(this.editorsCache.remove((Serializable)((Object)id)));
                return bl;
            }
            finally {
                this.editorsLock.unlock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closed(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        String state = (String)this.editorsCache.get((Serializable)((Object)id));
        if (STATE_CLOSING.equals(state)) {
            this.editorsLock.lock();
            try {
                boolean bl = STATE_CLOSING.equals(this.editorsCache.remove((Serializable)((Object)id)));
                return bl;
            }
            finally {
                this.editorsLock.unlock();
            }
        }
        return false;
    }

    public boolean reset(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        return this.editorsCache.remove((Serializable)((Object)id)) != null;
    }

    public boolean isOpening(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        return STATE_OPENING.equals(this.editorsCache.get((Serializable)((Object)id)));
    }

    public boolean isOpen(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        return STATE_OPEN.equals(this.editorsCache.get((Serializable)((Object)id)));
    }

    public boolean isClosing(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        return STATE_CLOSING.equals(this.editorsCache.get((Serializable)((Object)id)));
    }

    public boolean isClosed(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        return this.editorsCache.get((Serializable)((Object)id)) == null;
    }

    public boolean canShow(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        String state = (String)this.editorsCache.get((Serializable)((Object)id));
        return STATE_OPENING.equals(state) || STATE_OPEN.equals(state) || STATE_CLOSING.equals(state);
    }

    public boolean canOpen(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        String state = (String)this.editorsCache.get((Serializable)((Object)id));
        return state == null || STATE_CLOSING.equals(state);
    }

    public boolean canClose(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        String state = (String)this.editorsCache.get((Serializable)((Object)id));
        return STATE_OPENING.equals(state) || STATE_OPEN.equals(state);
    }

    protected String editorId(String userId, String workspace, String path) {
        StringBuilder id = new StringBuilder();
        id.append(userId);
        id.append(':');
        id.append(workspace);
        id.append(':');
        id.append(path);
        return id.toString();
    }

    protected class EditorListener
    implements OnlyofficeEditorListener {
        protected EditorListener() {
        }

        @Override
        public void onCreate(Config config) {
            OnlyofficeEditorUIService.this.open(config.getEditorConfig().getUser().getId(), config.getWorkspace(), config.getPath());
        }

        @Override
        public void onGet(Config config) {
            OnlyofficeEditorUIService.this.open(config.getEditorConfig().getUser().getId(), config.getWorkspace(), config.getPath());
        }

        @Override
        public void onJoined(Config config) {
            OnlyofficeEditorUIService.this.opened(config.getEditorConfig().getUser().getId(), config.getWorkspace(), config.getPath());
        }

        @Override
        public void onLeaved(Config config) {
            OnlyofficeEditorUIService.this.reset(config.getEditorConfig().getUser().getId(), config.getWorkspace(), config.getPath());
        }

        @Override
        public void onSaved(Config config) {
            OnlyofficeEditorUIService.this.reset(config.getEditorConfig().getUser().getId(), config.getWorkspace(), config.getPath());
        }

        @Override
        public void onError(Config config) {
        }
    }
}

