/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.videocalls;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.videocalls.CallInfo;
import org.exoplatform.videocalls.GroupInfo;
import org.exoplatform.videocalls.IdentityInfo;
import org.exoplatform.videocalls.IdentityNotFound;
import org.exoplatform.videocalls.ParticipantInfo;
import org.exoplatform.videocalls.UserInfo;
import org.exoplatform.videocalls.VideoCallsProvider;
import org.exoplatform.videocalls.VideoCallsProviderException;
import org.picocontainer.Startable;

public class VideoCallsService
implements Startable {
    public static final String SPACE_TYPE_NAME = "space";
    public static final String CHAT_ROOM_TYPE_NAME = "chat_room";
    protected static final String CALL_OWNER_SCOPE_NAME = "videocalls.callOwner";
    public static final String OWNER_TYPE_USER = "user";
    public static final String OWNER_TYPE_SPACE = "space";
    public static final String OWNER_TYPE_CHATROOM = "chat_room";
    protected static final Log LOG = ExoLogger.getLogger(VideoCallsService.class);
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviders;
    protected final NodeHierarchyCreator hierarchyCreator;
    protected final OrganizationService organization;
    protected final IdentityManager socialIdentityManager;
    protected final ManageDriveService driveService;
    protected final ListenerService listenerService;
    protected final SettingService settingService;
    protected final Map<String, VideoCallsProvider> providers = new ConcurrentHashMap<String, VideoCallsProvider>();
    protected SpaceService spaceService;
    protected final Map<String, CallInfo> calls = new ConcurrentHashMap<String, CallInfo>();

    public VideoCallsService(RepositoryService jcrService, SessionProviderService sessionProviders, NodeHierarchyCreator hierarchyCreator, OrganizationService organization, IdentityManager socialIdentityManager, ManageDriveService driveService, ListenerService listenerService, SettingService settingService) {
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
        this.hierarchyCreator = hierarchyCreator;
        this.organization = organization;
        this.socialIdentityManager = socialIdentityManager;
        this.driveService = driveService;
        this.listenerService = listenerService;
        this.settingService = settingService;
    }

    public UserInfo getUserInfo(String id) throws Exception {
        User user = this.organization.getUserHandler().findUserByName(id);
        Identity userIdentity = this.socialIdentityManager.getOrCreateIdentity("organization", id, true);
        if (user != null) {
            if (userIdentity != null) {
                Profile socialProfile = this.socialIdentityManager.getProfile(userIdentity);
                List ims = (List)socialProfile.getProperty("ims");
                UserInfo info = new UserInfo(user.getUserName(), user.getFirstName(), user.getLastName());
                if (ims != null) {
                    for (Map m : ims) {
                        VideoCallsProvider provider;
                        String imType = (String)m.get("key");
                        String imId = (String)m.get("value");
                        if (imId == null || imId.length() <= 0 || (provider = this.providers.get(imType)) == null || !provider.isSupportedType(imType)) continue;
                        try {
                            info.addImAccount(provider.getIMInfo(imId));
                        }
                        catch (VideoCallsProviderException e) {
                            LOG.warn((Object)e.getMessage());
                        }
                    }
                }
                info.setAvatarUri(socialProfile.getAvatarUrl());
                info.setProfileUri(LinkProvider.getUserProfileUri((String)id));
                return info;
            }
            LOG.warn((Object)("Social identity not found for " + user.getUserName() + " (" + user.getFirstName() + " " + user.getLastName() + ")"));
        } else {
            LOG.warn((Object)("User not found: " + id));
        }
        return null;
    }

    public SpaceInfo getSpaceInfo(String spacePrettyName) throws Exception {
        Space socialSpace = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        SpaceInfo space = new SpaceInfo(socialSpace);
        for (String sm : socialSpace.getMembers()) {
            UserInfo user = this.getUserInfo(sm);
            if (user == null) continue;
            space.addMember(user);
        }
        space.setCallId(this.readCallId(spacePrettyName));
        return space;
    }

    public RoomInfo getRoomInfo(String id, String name, String title, String[] members) throws Exception {
        RoomInfo room = new RoomInfo(id, name, title);
        for (String userName : members) {
            UserInfo user = this.getUserInfo(userName);
            if (user == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Skipped not found user: " + userName));
                }
                throw new IdentityNotFound("User " + userName + " not found or not accessible");
            }
            room.addMember(user);
        }
        room.setCallId(this.readCallId(id));
        return room;
    }

    public CallInfo addCallInfo(String id, String ownerId, String ownerType, String title, String providerType, Collection<String> parts) throws Exception {
        String ownerAvatar;
        String ownerUri;
        IdentityInfo owner;
        boolean isUser = OWNER_TYPE_USER.equals(ownerType);
        boolean isSpace = "space".equals(ownerType);
        if (isUser) {
            UserInfo userInfo = this.getUserInfo(ownerId);
            if (userInfo == null) {
                owner = new RoomInfo(ownerId, ownerId, title);
                ownerUri = ParticipantInfo.EMPTY_NAME;
                ownerAvatar = "/eXoSkin/skin/images/system/UserAvtDefault.png";
            } else {
                owner = userInfo;
                ownerUri = userInfo.getProfileUri();
                ownerAvatar = userInfo.getAvatarUri();
                if (ownerAvatar == null) {
                    ownerAvatar = "/eXoSkin/skin/images/system/UserAvtDefault.png";
                }
            }
        } else if (isSpace) {
            Space space = this.spaceService.getSpaceByPrettyName(ownerId);
            if (space != null) {
                owner = new SpaceInfo(space);
                ownerUri = space.getUrl();
                ownerAvatar = space.getAvatarUrl();
                if (ownerAvatar == null) {
                    ownerAvatar = "/eXoSkin/skin/images/system/SpaceAvtDefault.png";
                }
            } else {
                LOG.warn((Object)("Cannot find call's owner space " + ownerId));
                owner = new RoomInfo(ownerId, ownerId, title);
                ownerUri = ParticipantInfo.EMPTY_NAME;
                ownerAvatar = "/eXoSkin/skin/images/system/SpaceAvtDefault.png";
            }
            this.saveCallId(ownerId, id);
        } else {
            owner = new RoomInfo(ownerId, ownerId, title);
            ownerUri = ParticipantInfo.EMPTY_NAME;
            ownerAvatar = "/eXoSkin/skin/images/system/SpaceAvtDefault.png";
            this.saveCallId(ownerId, id);
        }
        CallInfo call = new CallInfo(providerType, title, owner, ownerType, ownerUri, ownerAvatar);
        for (String pid : parts) {
            UserInfo part = this.getUserInfo(pid);
            if (part != null) {
                call.addParticipant(part);
                continue;
            }
            call.addParticipant(new ParticipantInfo(providerType, pid));
        }
        this.calls.put(id, call);
        return call;
    }

    public CallInfo getCallInfo(String id) throws Exception {
        return this.calls.get(id);
    }

    public CallInfo removeCallInfo(String id) throws Exception {
        return this.calls.remove(id);
    }

    public void addPlugin(ComponentPlugin plugin) {
        Class<VideoCallsProvider> pclass = VideoCallsProvider.class;
        if (pclass.isAssignableFrom(plugin.getClass())) {
            this.addProvider((VideoCallsProvider)((Object)pclass.cast(plugin)));
        } else {
            LOG.warn((Object)("Video Calls provider plugin is not an instance of " + pclass.getName() + ". Skipped plugin: " + plugin));
        }
    }

    public void addProvider(VideoCallsProvider provider) {
        for (String type : provider.getSupportedTypes()) {
            VideoCallsProvider existing = this.providers.putIfAbsent(type, provider);
            if (existing == null) continue;
            LOG.warn((Object)("Video Calls provider type '" + existing.getType() + "' already registered. Skipped plugin: " + (Object)((Object)provider)));
        }
    }

    public VideoCallsProvider getProvider(String type) {
        return this.providers.get(type);
    }

    public void start() {
        this.spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
    }

    public void stop() {
    }

    protected boolean isSpaceMember(String userName, String spacePrettyName) {
        return this.getSpaceMembers(spacePrettyName).contains(userName);
    }

    protected Set<String> getSpaceMembers(String spacePrettyName) {
        Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        HashSet<String> spaceMembers = new HashSet<String>();
        for (String sm : space.getMembers()) {
            spaceMembers.add(sm);
        }
        return spaceMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveCallId(String ownerId, String callId) {
        String initialGlobalId = Scope.GLOBAL.getId();
        try {
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(CALL_OWNER_SCOPE_NAME), ownerId, SettingValue.create((String)callId));
        }
        finally {
            Scope.GLOBAL.id(initialGlobalId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readCallId(String ownerId) {
        String initialGlobalId = Scope.GLOBAL.getId();
        try {
            SettingValue val = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(CALL_OWNER_SCOPE_NAME), ownerId);
            if (val != null) {
                String string = String.valueOf(val.getValue());
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            Scope.GLOBAL.id(initialGlobalId);
        }
    }

    public class RoomInfo
    extends GroupInfo {
        protected final String name;

        public RoomInfo(String id, String name, String title) {
            super(id, title);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return "chat_room";
        }
    }

    public class SpaceInfo
    extends GroupInfo {
        protected final String groupId;

        public SpaceInfo(Space socialSpace) {
            super(socialSpace.getPrettyName(), socialSpace.getDisplayName());
            this.groupId = socialSpace.getGroupId();
        }

        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public String getType() {
            return "space";
        }
    }
}

