/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.videocalls.skype.server;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.web.filter.Filter;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class SkypeCallFilter
extends AbstractFilter
implements Filter {
    protected static final Logger LOG = LoggerFactory.getLogger(SkypeCallFilter.class);
    public static final String SKYPE_CALL_REDIRECT = "skypecall_redirect";
    public static final String SKYPE_SERVLET_CTX = "/skype";
    public static final String CALL_SERVLET = "/skypecallservlet".intern();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpServletResponse httpRes = (HttpServletResponse)response;
        if (httpReq.getRemoteUser() != null) {
            String uri = httpReq.getRequestURI();
            if (uri.endsWith("/skype/call/home")) {
                httpReq.setAttribute(SKYPE_CALL_REDIRECT, (Object)"/portal");
            }
            ServletContext skypeContext = httpReq.getSession().getServletContext().getContext(SKYPE_SERVLET_CTX);
            skypeContext.getRequestDispatcher(CALL_SERVLET).forward((ServletRequest)httpReq, (ServletResponse)httpRes);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

