/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.videocalls;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.videocalls.GroupInfo;
import org.exoplatform.videocalls.UserInfo;
import org.exoplatform.videocalls.VideoCallsProvider;
import org.exoplatform.videocalls.VideoCallsProviderException;
import org.picocontainer.Startable;

public class VideoCallsService
implements Startable {
    protected static final Log LOG = ExoLogger.getLogger(VideoCallsService.class);
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviders;
    protected final NodeHierarchyCreator hierarchyCreator;
    protected final OrganizationService organization;
    protected final IdentityManager socialIdentityManager;
    protected final ManageDriveService driveService;
    protected final ListenerService listenerService;
    protected final Map<String, VideoCallsProvider> providers = new ConcurrentHashMap<String, VideoCallsProvider>();
    protected SpaceService spaceService;

    public VideoCallsService(RepositoryService jcrService, SessionProviderService sessionProviders, NodeHierarchyCreator hierarchyCreator, OrganizationService organization, IdentityManager socialIdentityManager, ManageDriveService driveService, ListenerService listenerService) {
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
        this.hierarchyCreator = hierarchyCreator;
        this.organization = organization;
        this.socialIdentityManager = socialIdentityManager;
        this.driveService = driveService;
        this.listenerService = listenerService;
    }

    public UserInfo getUserInfo(String id) throws Exception {
        User user = this.organization.getUserHandler().findUserByName(id);
        Identity userIdentity = this.socialIdentityManager.getOrCreateIdentity("organization", id, true);
        if (user != null && userIdentity != null) {
            Profile socialProfile = this.socialIdentityManager.getProfile(userIdentity);
            List ims = (List)socialProfile.getProperty("ims");
            UserInfo info = new UserInfo(user.getUserName(), user.getFirstName(), user.getLastName());
            if (ims != null) {
                for (Map m : ims) {
                    VideoCallsProvider provider;
                    String imType = (String)m.get("key");
                    String imId = (String)m.get("value");
                    if (imId == null || imId.length() <= 0 || (provider = this.providers.get(imType)) == null || !provider.isSupportedType(imType)) continue;
                    try {
                        info.addImAccount(provider.getIMInfo(imId));
                    }
                    catch (VideoCallsProviderException e) {
                        LOG.warn((Object)e.getMessage());
                    }
                }
            }
            return info;
        }
        return null;
    }

    public SpaceInfo getSpaceInfo(String spacePrettyName) throws Exception {
        Space socialSpace = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        SpaceInfo space = new SpaceInfo(socialSpace);
        for (String sm : socialSpace.getMembers()) {
            UserInfo user = this.getUserInfo(sm);
            space.addMember(user);
        }
        return space;
    }

    public void addPlugin(ComponentPlugin plugin) {
        Class<VideoCallsProvider> pclass = VideoCallsProvider.class;
        if (pclass.isAssignableFrom(plugin.getClass())) {
            this.addProvider((VideoCallsProvider)((Object)pclass.cast(plugin)));
        } else {
            LOG.warn((Object)("Video Calls provider plugin is not an instance of " + pclass.getName() + ". Skipped plugin: " + plugin));
        }
    }

    public void addProvider(VideoCallsProvider provider) {
        for (String type : provider.getSupportedTypes()) {
            VideoCallsProvider existing = this.providers.putIfAbsent(type, provider);
            if (existing == null) continue;
            LOG.warn((Object)("Video Calls provider type '" + existing.getType() + "' already registered. Skipped plugin: " + (Object)((Object)provider)));
        }
    }

    public VideoCallsProvider getProvider(String type) {
        return this.providers.get(type);
    }

    public void start() {
        this.spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
    }

    public void stop() {
    }

    protected boolean isSpaceMember(String userName, String spacePrettyName) {
        return this.getSpaceMembers(spacePrettyName).contains(userName);
    }

    protected Set<String> getSpaceMembers(String spacePrettyName) {
        Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        HashSet<String> spaceMembers = new HashSet<String>();
        for (String sm : space.getMembers()) {
            spaceMembers.add(sm);
        }
        return spaceMembers;
    }

    public class SpaceInfo
    extends GroupInfo {
        protected final String prettyName;
        protected final Map<String, UserInfo> members;

        public SpaceInfo(Space socialSpace) {
            super(socialSpace.getGroupId(), socialSpace.getDisplayName());
            this.members = new LinkedHashMap<String, UserInfo>();
            this.prettyName = socialSpace.getPrettyName();
        }

        @Override
        public Map<String, UserInfo> getMembers() {
            return Collections.unmodifiableMap(this.members);
        }

        protected void addMember(UserInfo user) {
            this.members.put(user.getName(), user);
        }

        public String getPrettyName() {
            return this.prettyName;
        }
    }
}

