/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.videocalls;

import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.social.common.router.ExoRouter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.videocalls.ContextInfo;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class VideoCallsUtils {
    public static String spaceRoomName(String spacePrettyName) {
        StringBuilder sname = new StringBuilder();
        sname.append("eXoVideoCalls");
        for (String s : spacePrettyName.split("_")) {
            if (s.length() <= 0) continue;
            sname.append(Character.toUpperCase(s.charAt(0)));
            if (s.length() <= 1) continue;
            sname.append(s.substring(1));
        }
        sname.append("Space");
        return sname.toString();
    }

    public static Space getSpaceByContext() {
        SpaceService spaceService;
        WebuiRequestContext webuiContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (webuiContext != null && (spaceService = (SpaceService)webuiContext.getUIApplication().getApplicationComponent(SpaceService.class)) != null) {
            String spacePrettyName = VideoCallsUtils.getSpaceNameByContext();
            return spaceService.getSpaceByPrettyName(spacePrettyName);
        }
        return null;
    }

    public static String getSpaceNameByContext() {
        PortalRequestContext portlalContext;
        String requestPath;
        ExoRouter.Route route;
        WebuiRequestContext webuiContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (webuiContext != null && (route = ExoRouter.route((String)(requestPath = (portlalContext = webuiContext instanceof PortalRequestContext ? (PortalRequestContext)webuiContext : (PortalRequestContext)webuiContext.getParentAppRequestContext()).getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH)))) != null && portlalContext.getSiteType().equals((Object)SiteType.GROUP) && portlalContext.getSiteName().startsWith("/spaces")) {
            return (String)route.localArgs.get("spacePrettyName");
        }
        return null;
    }

    public static ContextInfo getCurrentContext() {
        String spaceRoomName;
        String spacePrettyName = VideoCallsUtils.getSpaceNameByContext();
        if (spacePrettyName != null) {
            spaceRoomName = VideoCallsUtils.spaceRoomName(spacePrettyName);
        } else {
            spacePrettyName = spaceRoomName = "".intern();
        }
        return new ContextInfo(spacePrettyName, spaceRoomName);
    }

    public static String asJSON(Object obj) throws JsonException {
        JsonValue value = new JsonGeneratorImpl().createJsonObject(obj);
        return value.toString();
    }
}

