/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.videocalls.portlet;

import java.io.IOException;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.videocalls.ContextInfo;
import org.exoplatform.videocalls.UserInfo;
import org.exoplatform.videocalls.VideoCallsService;
import org.exoplatform.videocalls.VideoCallsUtils;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;

public class VideoCallsPortlet
extends GenericPortlet {
    private static final Log LOG = ExoLogger.getLogger(VideoCallsPortlet.class);
    private VideoCallsService videocalls;

    public void init() throws PortletException {
        super.init();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.videocalls = (VideoCallsService)container.getComponentInstanceOfType(VideoCallsService.class);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String remoteUser = request.getRemoteUser();
        try {
            ContextInfo context = VideoCallsUtils.getCurrentContext();
            String contextJson = VideoCallsUtils.asJSON((Object)context);
            UserInfo exoUser = this.videocalls.getUserInfo(remoteUser);
            if (exoUser != null) {
                String exoUserJson = VideoCallsUtils.asJSON((Object)exoUser);
                JavascriptManager js = ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).getJavascriptManager();
                js.require("SHARED/videoCallsPortlet", "videoCallsPortlet").addScripts("videoCallsPortlet.start(" + exoUserJson + "," + contextJson + ");");
            } else {
                LOG.warn((Object)("Video Calls portlet cannot be initialized: user info cannot be obtained for " + remoteUser));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error processing Video Calls portlet for user " + remoteUser), (Throwable)e);
        }
    }
}

