/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.termsconditions;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.termsconditions.TermsAndConditionsService;
import org.exoplatform.web.filter.Filter;

public class TermsAndConditionsFilter
implements Filter {
    private static final String TERMS_AND_CONDITIONS_SERVLET_URL = "/terms-and-conditions";
    private static final String FUNCTIONAL_CONFIGURATION_EXTENSION_WAR = "/functional-configuration";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String remoteUserName = this.getRemoteUserName(httpServletRequest);
        TermsAndConditionsService termsAndConditionsService = this.getTermsAndConditionsService();
        if (termsAndConditionsService.isTermsAndConditionsActive() && StringUtils.isNotEmpty((String)remoteUserName) && !termsAndConditionsService.isTermsAndConditionsAcceptedBy(remoteUserName)) {
            ServletContext context = httpServletRequest.getSession().getServletContext().getContext(FUNCTIONAL_CONFIGURATION_EXTENSION_WAR);
            context.getRequestDispatcher(TERMS_AND_CONDITIONS_SERVLET_URL).forward((ServletRequest)httpServletRequest, response);
            return;
        }
        chain.doFilter(request, response);
    }

    private String getRemoteUserName(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getRemoteUser();
    }

    private TermsAndConditionsService getTermsAndConditionsService() {
        return (TermsAndConditionsService)CommonsUtils.getService(TermsAndConditionsService.class);
    }
}

