/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rest;

import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.exoplatform.highlight.spaces.HighlightSpacesService;
import org.exoplatform.rest.response.SpaceConfiguration;
import org.exoplatform.rest.response.TermsAndConditions;
import org.exoplatform.rest.utils.RestUtils;
import org.exoplatform.service.FunctionalConfigurationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/functional-configuration")
public class FunctionalConfigurationController
implements ResourceContainer {
    private static final String DOCUMENT_ACTIVITY_ENDPOINT = "/document-activity";
    private static final String CONFIGURATION_ENDPOINT = "/configuration";
    private static final String SPACES_BY_GROUP = "/group/{id}/spaces";
    private static final String COMPOSER_ACTIVITY_ENDPOINT = "/composer-activity";
    private static final String UPDATE_SPACE_CONFIGURATION_ENDPOINT = "/configuration/space";
    private static final String UPDATE_TERMS_AND_CONDITIONS = "/terms-and-conditions";
    private FunctionalConfigurationService functionalConfigurationService;
    private HighlightSpacesService highlightSpacesService;
    private static final Log LOGGER = ExoLogger.getLogger(FunctionalConfigurationService.class);

    public FunctionalConfigurationController(FunctionalConfigurationService functionalConfigurationService, HighlightSpacesService highlightSpacesService) {
        this.functionalConfigurationService = functionalConfigurationService;
        this.highlightSpacesService = highlightSpacesService;
    }

    @GET
    @Path(value="/group/{id}/spaces")
    public Response getHighlightedSpacesForGroup(@Context HttpServletRequest request, @PathParam(value="id") String spaceSGroupIdentifier) {
        return Response.ok(this.highlightSpacesService.getHighlightedSpacesForUser(spaceSGroupIdentifier, request.getRemoteUser()), (String)"application/json").build();
    }

    @GET
    @Path(value="/configuration")
    @RolesAllowed(value={"administrators"})
    public Response getConfiguration() {
        LOGGER.info((Object)"FunctionalConfiguration : GetConfiguration");
        return Response.ok((Object)this.functionalConfigurationService.getConfiguration(), (String)"application/json").build();
    }

    @PUT
    @Path(value="/document-activity")
    @RolesAllowed(value={"administrators"})
    public Response updateDocumentActionActivitiesVisibility(@QueryParam(value="hidden") String hidden) {
        LOGGER.info((Object)("FunctionalConfiguration : updateDocumentActionActivitiesVisibility, hidden=" + hidden));
        if (!RestUtils.isValidBooleanParameter(hidden)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.functionalConfigurationService.configureDocumentActionActivities(hidden);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/composer-activity")
    @RolesAllowed(value={"administrators"})
    public Response updateComposerActivity(@QueryParam(value="hidden") String hidden) {
        LOGGER.info((Object)("FunctionalConfiguration : updateComposerActivity, hidden=" + hidden));
        if (!RestUtils.isValidBooleanParameter(hidden)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.functionalConfigurationService.configureActivityComposer(hidden);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/configuration/space")
    @RolesAllowed(value={"administrators"})
    public Response updateSpaceConfiguration(SpaceConfiguration space) {
        LOGGER.info((Object)("FunctionalConfiguration : updateSpaceConfiguration for space " + space.getDisplayName()));
        SpaceConfiguration spaceConfiguration = this.functionalConfigurationService.updateSpaceConfiguration(space);
        return Response.ok((Object)spaceConfiguration, (String)"application/json").build();
    }

    @PUT
    @Path(value="/terms-and-conditions")
    @RolesAllowed(value={"administrators"})
    public Response updateTermsAndConditions(TermsAndConditions termsAndConditions) {
        LOGGER.info("FunctionalConfiguration : updateTermsAndConditions", new Object[]{termsAndConditions});
        this.functionalConfigurationService.updateTermsAndConditions(termsAndConditions);
        return Response.ok((Object)"application/json").build();
    }
}

