/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portlets.activityComposerConfiguration;

import java.util.List;
import javax.inject.Inject;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.plugin.ajax.Ajax;
import juzu.template.Template;
import org.exoplatform.service.FunctionalConfigurationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.json.JSONArray;
import org.json.JSONObject;

public class FunctionalConfigurationController {
    private static Log log = ExoLogger.getLogger(FunctionalConfigurationController.class);
    private static final String NAME = "name";
    private static final String LABEL = "label";
    private static final String SPACES_WITH_ACTIVITY_COMPOSER = "spacesWithActivityComposer";
    @Inject
    @Path(value="index.gtmpl")
    Template index;
    @Inject
    FunctionalConfigurationService functionalConfigurationService;

    @View
    public Response.Content index() throws Exception {
        return this.index.ok();
    }

    @Ajax
    @Resource
    public Response getSpacesWithoutActivityComposer() {
        JSONObject jsonGlobal = new JSONObject();
        try {
            List listSpacesWithoutActivityComposer = this.functionalConfigurationService.getListSpacesWithoutActivityComposer();
            JSONArray jsonArray = new JSONArray();
            for (Space spaceWithoutActivityComposer : listSpacesWithoutActivityComposer) {
                JSONObject json = new JSONObject();
                json.put(NAME, (Object)spaceWithoutActivityComposer.getPrettyName());
                json.put(LABEL, (Object)spaceWithoutActivityComposer.getDisplayName());
                jsonArray.put((Object)json);
            }
            jsonGlobal.put("spacesWithoutActivityComposer", (Object)jsonArray);
        }
        catch (Exception e) {
            log.error((Object)"Cannot get spaces without activity composer", (Throwable)e);
        }
        return Response.ok((CharSequence)jsonGlobal.toString());
    }

    @Ajax
    @Resource
    public Response getSpacesWithActivityComposer() {
        JSONObject jsonGlobal = new JSONObject();
        try {
            List listSpacesWithActivityComposer = this.functionalConfigurationService.getListSpacesWithActivityComposer();
            JSONArray jsonArray = new JSONArray();
            for (Space spaceWithActivityComposer : listSpacesWithActivityComposer) {
                JSONObject json = new JSONObject();
                json.put(NAME, (Object)spaceWithActivityComposer.getPrettyName());
                json.put(LABEL, (Object)spaceWithActivityComposer.getDisplayName());
                jsonArray.put((Object)json);
            }
            jsonGlobal.put(SPACES_WITH_ACTIVITY_COMPOSER, (Object)jsonArray);
        }
        catch (Exception e) {
            log.error((Object)"Cannot get spaces with activity composer", (Throwable)e);
        }
        return Response.ok((CharSequence)jsonGlobal.toString());
    }

    @Ajax
    @Resource
    public Response getUserActivityComposerState() {
        JSONObject jsonGlobal = new JSONObject();
        try {
            String userActivityComposerState = this.functionalConfigurationService.getUserActivityComposerState();
            jsonGlobal.put("hideUserActivityComposer", (Object)userActivityComposerState);
        }
        catch (Exception e) {
            log.error((Object)"Cannot get user activity composer state", (Throwable)e);
        }
        return Response.ok((CharSequence)jsonGlobal.toString());
    }

    @Ajax
    @Resource
    public Response hideSpaceActivityComposer(String spaces) {
        this.functionalConfigurationService.hideSpaceActivityComposer(spaces);
        return Response.ok();
    }

    @Ajax
    @Resource
    public Response showSpaceActivityComposer(String spaces) {
        this.functionalConfigurationService.showSpaceActivityComposer(spaces);
        return Response.ok();
    }

    @Ajax
    @Resource
    public Response configureUserActivityComposer(String hideUserActivityComposer) {
        this.functionalConfigurationService.configureActivityComposer(hideUserActivityComposer);
        return Response.ok();
    }
}

