/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.gamification.github.listener;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;

public class GithubEventsListener
extends Listener<Map<String, String>, String> {
    public static final String GAMIFICATION_GENERIC_EVENT = "exo.gamification.generic.action";
    public static final String GAMIFICATION_CANCEL_EVENT = "gamification.cancel.event.action";
    private final ListenerService listenerService;

    public GithubEventsListener(ListenerService listenerService) {
        this.listenerService = listenerService;
    }

    public void onEvent(Event<Map<String, String>, String> event) throws Exception {
        HashMap<String, String> gam = new HashMap<String, String>();
        gam.put("objectId", (String)((Map)event.getSource()).get("objectId"));
        gam.put("objectType", (String)((Map)event.getSource()).get("objectType"));
        gam.put("ruleTitle", (String)((Map)event.getSource()).get("ruleTitle"));
        gam.put("senderId", (String)((Map)event.getSource()).get("senderId"));
        gam.put("receiverId", (String)((Map)event.getSource()).get("receiverId"));
        this.listenerService.broadcast(this.getGamificationEventName(event.getEventName()), gam, (Object)"");
    }

    private String getGamificationEventName(String eventName) {
        return switch (eventName) {
            case "github.action.event" -> GAMIFICATION_GENERIC_EVENT;
            case "github.cancel.action.event" -> GAMIFICATION_CANCEL_EVENT;
            default -> throw new IllegalArgumentException("Unexpected listener event name: " + eventName);
        };
    }
}

