/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.gamification.github.rest;

import io.meeds.gamification.utils.Utils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.gamification.github.model.RemoteRepository;
import org.exoplatform.gamification.github.model.WebHook;
import org.exoplatform.gamification.github.rest.builder.WebHookBuilder;
import org.exoplatform.gamification.github.rest.model.RepositoryList;
import org.exoplatform.gamification.github.rest.model.WebHookList;
import org.exoplatform.gamification.github.rest.model.WebHookRestEntity;
import org.exoplatform.gamification.github.services.GithubConsumerService;
import org.exoplatform.gamification.github.services.WebhookService;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/gamification/connectors/github/hooks")
public class HooksManagementRest
implements ResourceContainer {
    public static final String GITHUB_HOOK_NOT_FOUND = "The GitHub hook doesn't exit";
    private final WebhookService webhookService;
    private final GithubConsumerService githubConsumerService;

    public HooksManagementRest(WebhookService webhookService, GithubConsumerService githubConsumerService) {
        this.webhookService = webhookService;
        this.githubConsumerService = githubConsumerService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves the list GitHub webHooks", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation")})
    public Response getWebHooks(@QueryParam(value="offset") int offset, @Parameter(description="Query results limit", required=true) @QueryParam(value="limit") int limit, @Parameter(description="WebHook total size") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize) {
        String currentUser = Utils.getCurrentUser();
        try {
            WebHookList webHookList = new WebHookList();
            List<WebHookRestEntity> webHookRestEntities = this.getWebHookRestEntities(currentUser);
            if (returnSize) {
                int webHookSize = this.webhookService.countWebhooks(currentUser, false);
                webHookList.setSize(webHookSize);
            }
            webHookList.setWebhooks(webHookRestEntities);
            webHookList.setOffset(offset);
            webHookList.setLimit(limit);
            return Response.ok((Object)webHookList).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{webHookId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves a webHook by its technical identifier", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getWebHookById(@Parameter(description="WebHook technical identifier", required=true) @PathParam(value="webHookId") long webHookId) {
        if (webHookId == 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"WebHook Id must be not null").build();
        }
        String currentUser = Utils.getCurrentUser();
        try {
            WebHook webHook = this.webhookService.getWebhookId(webHookId, currentUser);
            return Response.ok((Object)WebHookBuilder.toRestEntity(this.webhookService, this.githubConsumerService, webHook)).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Create a organization webhook for Remote GitHub connector.", description="Create a organization webhook for Remote GitHub connector.", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createWebhookHook(@Parameter(description="GitHub organization name", required=true) @FormParam(value="organizationName") String organizationName, @Parameter(description="GitHub personal access token", required=true) @FormParam(value="accessToken") String accessToken) {
        if (StringUtils.isBlank((String)organizationName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'organizationName' parameter is mandatory").build();
        }
        if (StringUtils.isBlank((String)accessToken)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'accessToken' parameter is mandatory").build();
        }
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        try {
            this.webhookService.createWebhook(organizationName, accessToken, currentUser);
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectAlreadyExistsException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
    }

    @PATCH
    @Consumes(value={"application/x-www-form-urlencoded"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Update a organization webhook personal access token.", description="Update a organization webhook personal access token.", method="PATCH")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateWebHookAccessToken(@Parameter(description="webHook id", required=true) @FormParam(value="webHookId") long webHookId, @Parameter(description="GitHub personal access token", required=true) @FormParam(value="accessToken") String accessToken) {
        if (webHookId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'webHookId' must be positive").build();
        }
        if (StringUtils.isBlank((String)accessToken)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'accessToken' parameter is mandatory").build();
        }
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        try {
            this.webhookService.updateWebHookAccessToken(webHookId, accessToken, currentUser);
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)GITHUB_HOOK_NOT_FOUND).build();
        }
    }

    @DELETE
    @Path(value="{organizationId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes gitHub organization webhook", description="Deletes gitHub organization webhook", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteWebhookHook(@Parameter(description="GitHub organization id", required=true) @PathParam(value="organizationId") long organizationId) {
        if (organizationId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'hookName' parameter is mandatory").build();
        }
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        try {
            this.webhookService.deleteWebhookHook(organizationId, currentUser);
            return Response.noContent().build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).type("text/plain").build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)GITHUB_HOOK_NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="{organizationId}/repos")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves the list GitHub organization repositories", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation")})
    public Response getWebHookRepos(@Parameter(description="GitHub organization id", required=true) @PathParam(value="organizationId") long organizationId, @Parameter(description="Query page number", required=true) @QueryParam(value="page") int page, @Parameter(description="Query item per page", required=true) @QueryParam(value="perPage") int perPage, @Parameter(description="Keyword to search in repositories title", required=true) @QueryParam(value="keyword") String keyword) {
        String currentUser = Utils.getCurrentUser();
        try {
            RepositoryList repositoryList = new RepositoryList();
            List<RemoteRepository> remoteRepositories = this.webhookService.retrieveOrganizationRepos(organizationId, currentUser, page, perPage, keyword);
            repositoryList.setRemoteRepositories(remoteRepositories);
            repositoryList.setPage(page);
            repositoryList.setPerPage(perPage);
            return Response.ok((Object)repositoryList).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)GITHUB_HOOK_NOT_FOUND).build();
        }
    }

    @Path(value="repo/status")
    @POST
    @RolesAllowed(value={"users"})
    @Operation(summary="enables/disables webhook repository.", description="enables/disables webhook repository", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateWebHookRepoStatus(@Parameter(description="GitHub organization remote Id", required=true) @FormParam(value="organizationId") long organizationId, @Parameter(description="Organization repository remote Id", required=true) @FormParam(value="repositoryId") long repositoryId, @Parameter(description="Organization repository status enabled/disabled. possible values: true for enabled, else false", required=true) @FormParam(value="enabled") boolean enabled) {
        String currentUser = Utils.getCurrentUser();
        try {
            this.webhookService.setWebHookRepositoryEnabled(organizationId, repositoryId, enabled, currentUser);
            return Response.noContent().build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).type("text/plain").build();
        }
    }

    @Path(value="events/status")
    @POST
    @RolesAllowed(value={"users"})
    @Operation(summary="enables/disables event for gitHub organization.", description="enables/disables event for gitHub organization", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateWebHookEventStatus(@Parameter(description="Event Id", required=true) @FormParam(value="eventId") long eventId, @Parameter(description="Organization remote Id", required=true) @FormParam(value="organizationId") long organizationId, @Parameter(description="Event status enabled/disabled. possible values: true for enabled, else false", required=true) @FormParam(value="enabled") boolean enabled) {
        String currentUser = Utils.getCurrentUser();
        try {
            this.webhookService.setEventEnabledForOrganization(eventId, organizationId, enabled, currentUser);
            return Response.noContent().build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).type("text/plain").build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Event not found").build();
        }
    }

    @Path(value="watchScope/status")
    @POST
    @RolesAllowed(value={"users"})
    @Operation(summary="Limit webhook watch scope or not", description="Limit webhook watch scope or not", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateWebHookWatchScope(@Parameter(description="GitHub organization remote Id", required=true) @FormParam(value="organizationId") long organizationId, @Parameter(description="webhook watch scope limited status enabled/disabled. possible values: true for enabled, else false", required=true) @FormParam(value="enabled") boolean enabled) {
        String currentUser = Utils.getCurrentUser();
        try {
            this.webhookService.setWebHookWatchLimitEnabled(organizationId, enabled, currentUser);
            return Response.noContent().build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).type("text/plain").build();
        }
    }

    @Path(value="forceUpdate")
    @PATCH
    @RolesAllowed(value={"users"})
    @Operation(summary="Force Update a github stored webhooks", description="Force Update a github stored webhooks", method="PATCH")
    @ApiResponses(value={@ApiResponse(responseCode="500", description="Internal server error")})
    public Response forceUpdateWebhooks() {
        try {
            this.webhookService.forceUpdateWebhooks();
            return Response.noContent().build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    private List<WebHookRestEntity> getWebHookRestEntities(String username) throws IllegalAccessException {
        List<WebHook> webHooks = this.webhookService.getWebhooks(username, 0, 20, false);
        return WebHookBuilder.toRestEntities(this.webhookService, this.githubConsumerService, webHooks);
    }
}

