/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.github.storage.mapper;

import io.meeds.gamification.github.entity.WebhookEntity;
import io.meeds.gamification.github.model.WebHook;
import io.meeds.gamification.utils.Utils;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.social.core.manager.IdentityManager;

public class WebHookMapper {
    private WebHookMapper() {
    }

    public static WebhookEntity toEntity(WebHook webHook) {
        if (webHook == null) {
            return null;
        }
        WebhookEntity webhookEntity = new WebhookEntity();
        if (webHook.getId() > 0L) {
            webhookEntity.setId(webHook.getId());
        }
        if (webHook.getOrganizationId() > 0L) {
            webhookEntity.setOrganizationId(webHook.getOrganizationId());
        }
        if (StringUtils.isNotEmpty((CharSequence)webHook.getOrganizationName())) {
            webhookEntity.setOrganizationName(webHook.getOrganizationName());
        }
        if (webHook.getWebhookId() > 0L) {
            webhookEntity.setWebhookId(webHook.getWebhookId());
        }
        if (webHook.getWatchedBy() != null) {
            IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            String userIdentityId = identityManager.getOrCreateUserIdentity(webHook.getWatchedBy()).getId();
            webhookEntity.setWatchedBy(Long.parseLong(userIdentityId));
        }
        if (CollectionUtils.isNotEmpty(webHook.getTriggers())) {
            webhookEntity.setTriggers(webHook.getTriggers());
        }
        if (StringUtils.isNotEmpty((CharSequence)webHook.getToken())) {
            webhookEntity.setToken(io.meeds.gamification.github.utils.Utils.encode(webHook.getToken()));
        }
        if (StringUtils.isNotEmpty((CharSequence)webHook.getSecret())) {
            webhookEntity.setSecret(io.meeds.gamification.github.utils.Utils.encode(webHook.getSecret()));
        }
        return webhookEntity;
    }

    public static WebHook fromEntity(WebhookEntity webhookEntity) {
        if (webhookEntity == null) {
            return null;
        }
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        String watchedBy = identityManager.getIdentity(String.valueOf(webhookEntity.getWatchedBy())).getRemoteId();
        return new WebHook(webhookEntity.getId(), webhookEntity.getWebhookId(), webhookEntity.getOrganizationId(), webhookEntity.getOrganizationName(), webhookEntity.getTriggers(), webhookEntity.getEnabled(), webhookEntity.getWatchedDate() != null ? Utils.toSimpleDateFormat((Date)webhookEntity.getWatchedDate()) : null, watchedBy, webhookEntity.getUpdatedDate() != null ? Utils.toSimpleDateFormat((Date)webhookEntity.getUpdatedDate()) : null, webhookEntity.getRefreshDate() != null ? Utils.toSimpleDateFormat((Date)webhookEntity.getRefreshDate()) : null, io.meeds.gamification.github.utils.Utils.decode(webhookEntity.getToken()), io.meeds.gamification.github.utils.Utils.decode(webhookEntity.getSecret()));
    }
}

