/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.addons.gamification.service.configuration.BadgeService;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.BadgeDTO;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;

@Path(value="/gamification/badges")
@Produces(value={"application/json"})
@RolesAllowed(value={"administrators"})
public class ManageBadgesEndpoint
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ManageBadgesEndpoint.class);
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private final CacheControl cacheControl = new CacheControl();
    protected BadgeService badgeService = null;
    protected RuleService ruleService = null;
    protected FileService fileService = null;
    protected UploadService uploadService = null;

    public ManageBadgesEndpoint() {
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
        this.badgeService = (BadgeService)CommonsUtils.getService(BadgeService.class);
        this.ruleService = (RuleService)CommonsUtils.getService(RuleService.class);
        this.fileService = (FileService)CommonsUtils.getService(FileService.class);
        this.uploadService = (UploadService)CommonsUtils.getService(UploadService.class);
    }

    @GET
    @Path(value="/all")
    public Response getAllBadges(@Context UriInfo uriInfo) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            try {
                List<BadgeDTO> allBadges = this.badgeService.getAllBadges();
                return Response.ok(allBadges, (String)"application/json").cacheControl(this.cacheControl).build();
            }
            catch (Exception e) {
                LOG.error((Object)"Error listing all badges ", (Throwable)e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error listing all badges").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @POST
    @Path(value="/add")
    public Response addBadge(@Context UriInfo uriInfo, BadgeDTO badgeDTO) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            String currentUserName = conversationState.getIdentity().getUserId();
            try {
                badgeDTO.setId(null);
                badgeDTO.setCreatedBy(currentUserName);
                badgeDTO.setLastModifiedBy(currentUserName);
                badgeDTO.setCreatedDate(formatter.format(new Date()));
                badgeDTO.setLastModifiedDate(formatter.format(new Date()));
                if (badgeDTO.getUploadId() != null) {
                    UploadResource uploadResource = this.uploadService.getUploadResource(badgeDTO.getUploadId());
                    FileItem fileItem = null;
                    fileItem = new FileItem(null, badgeDTO.getTitle().toLowerCase(), uploadResource.getMimeType(), "gamification", (long)uploadResource.getUploadedSize(), new Date(), currentUserName, false, (InputStream)new FileInputStream(uploadResource.getStoreLocation()));
                    fileItem = this.fileService.writeFile(fileItem);
                    badgeDTO.setIconFileId(fileItem.getFileInfo().getId());
                }
                badgeDTO = this.badgeService.addBadge(badgeDTO);
                return Response.ok().cacheControl(this.cacheControl).entity((Object)badgeDTO).build();
            }
            catch (Exception e) {
                LOG.error("Error adding new badge {} by {} ", new Object[]{badgeDTO.getTitle(), currentUserName, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error adding new badge").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @PUT
    @Path(value="/update")
    public Response updateBadge(@Context UriInfo uriInfo, @Context HttpServletRequest request, BadgeDTO badgeDTO) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            String currentUserName = conversationState.getIdentity().getUserId();
            try {
                Locale lc = request.getLocale();
                badgeDTO.setCreatedBy(currentUserName);
                badgeDTO.setLastModifiedBy(currentUserName);
                badgeDTO.setLastModifiedDate(formatter.format(new Date()));
                badgeDTO = this.badgeService.updateBadge(badgeDTO);
                return Response.ok().cacheControl(this.cacheControl).entity((Object)badgeDTO).build();
            }
            catch (Exception e) {
                LOG.error("Error updating badge {} by {} ", new Object[]{badgeDTO.getTitle(), currentUserName, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error adding new badge").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @DELETE
    @Path(value="/delete")
    public Response deleteBadge(@Context UriInfo uriInfo, @QueryParam(value="badgeTitle") String badgeTitle) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            try {
                this.badgeService.deleteBadge(badgeTitle);
                return Response.ok((Object)("Deleted " + badgeTitle), (String)"application/json").cacheControl(this.cacheControl).build();
            }
            catch (Exception e) {
                LOG.error("Error deleting badge {} by {} ", new Object[]{badgeTitle, conversationState.getIdentity().getUserId(), e});
                return Response.status((int)500).cacheControl(this.cacheControl).build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }
}

