/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage.dao;

import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.TypedQuery;
import org.exoplatform.addons.gamification.entities.domain.configuration.BadgeEntity;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class BadgeDAO
extends GenericDAOJPAImpl<BadgeEntity, Long> {
    public BadgeEntity findBadgeByTitle(String badgeTitle) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationBadge.findBadgeByTitle", BadgeEntity.class).setParameter("badgeTitle", (Object)badgeTitle);
        try {
            return (BadgeEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public BadgeEntity findBadgeByNeededScore(String neededScore) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationBadge.findBadgeByNeededScore", BadgeEntity.class).setParameter("neededScore", (Object)neededScore);
        try {
            return (BadgeEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<BadgeEntity> getAllBadges() throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationBadge.getAllBadges", BadgeEntity.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public int deleteBadgeById(int badgeId) throws PersistenceException {
        return this.getEntityManager().createNamedQuery("GamificationBadge.deleteBadgeById").setParameter("badgeId", (Object)badgeId).executeUpdate();
    }

    public int deleteBadgeByTitle(String badgeTitle) throws PersistenceException {
        return this.getEntityManager().createNamedQuery("GamificationBadge.deleteBadgeByTitle").setParameter("badgeTitle", (Object)badgeTitle).executeUpdate();
    }

    public void clear() {
        this.getEntityManager().clear();
    }
}

