/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage.dao;

import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.TypedQuery;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextEntity;
import org.exoplatform.addons.gamification.service.effective.GamificationSearch;
import org.exoplatform.addons.gamification.service.effective.Leaderboard;
import org.exoplatform.addons.gamification.service.effective.Piechart;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class GamificationDAO
extends GenericDAOJPAImpl<GamificationContextEntity, Long> {
    private static final Log LOG = ExoLogger.getLogger(GamificationDAO.class);
    private int queryLimitOffset;

    public GamificationDAO(InitParams params) {
        ValueParam offsetLimit = params.getValueParam("query-limit-offset");
        try {
            if (offsetLimit != null) {
                this.queryLimitOffset = Integer.parseInt(offsetLimit.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            this.queryLimitOffset = 10;
            LOG.error("Error while parsing query-limit-offset, the default value will be used {}", new Object[]{this.queryLimitOffset, nfe});
        }
    }

    public GamificationContextEntity findGamificationContextByUsername(String username) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationUserReputation.findGamificationContextByUsername", GamificationContextEntity.class).setParameter("username", (Object)username);
        try {
            return (GamificationContextEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public GamificationContextEntity getUserGlobalScore(String username) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationUserReputation.findGamificationContextByUsername", GamificationContextEntity.class).setParameter("username", (Object)username);
        try {
            return (GamificationContextEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<GamificationContextEntity> search(GamificationSearch gamificationSearch) throws PersistenceException {
        return null;
    }

    public GamificationContextEntity getUserGamification(String username) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationUserReputation.findGamificationContextByUsername", GamificationContextEntity.class).setParameter("username", (Object)username);
        try {
            return (GamificationContextEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<Leaderboard> findLeaderboardByDomain(String domain) throws PersistenceException {
        List leaderBoards = this.getEntityManager().createNamedQuery("GamificationUserReputation.findLeaderboardByDomain").setParameter("domain", (Object)domain).getResultList();
        try {
            return leaderBoards;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<GamificationContextEntity> findOverallLeaderboard() throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationUserReputation.findOverallLeaderboard", GamificationContextEntity.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<Piechart> findStatsByUserId(String userId) throws PersistenceException {
        List pieChart = this.getEntityManager().createNamedQuery("GamificationUserReputation.findStatsByUserId").setParameter("userId", (Object)userId).setMaxResults(this.queryLimitOffset).getResultList();
        try {
            return pieChart;
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

