/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.social.relationship;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextEntity;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextItemEntity;
import org.exoplatform.addons.gamification.listener.GamificationListener;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.dto.effective.GamificationContextHolder;
import org.exoplatform.addons.gamification.service.effective.GamificationProcessor;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.relationship.RelationshipEvent;
import org.exoplatform.social.core.relationship.RelationshipListenerPlugin;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.spi.SpaceService;

public class GamificationRelationshipListener
extends RelationshipListenerPlugin
implements GamificationListener {
    private static final Log LOG = ExoLogger.getLogger(GamificationRelationshipListener.class);
    protected RuleService ruleService = (RuleService)CommonsUtils.getService(RuleService.class);
    protected GamificationProcessor gamificationProcessor = (GamificationProcessor)CommonsUtils.getService(GamificationProcessor.class);
    protected IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
    protected SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
    protected GamificationService gamificationService = (GamificationService)CommonsUtils.getService(GamificationService.class);

    public void confirmed(RelationshipEvent event) {
        List<GamificationContextHolder> gamificationContextEntityList = null;
        Identity sender = ((Relationship)event.getPayload()).getSender();
        RuleDTO ruleDto = null;
        ruleDto = this.ruleService.findEnableRuleByTitle("sendRelationshipRequest");
        if (ruleDto != null) {
            try {
                gamificationContextEntityList = this.gamify(ruleDto, sender.getId());
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
        Identity receiver = ((Relationship)event.getPayload()).getReceiver();
        ruleDto = this.ruleService.findEnableRuleByTitle("receiveRelationshipRequest");
        if (ruleDto != null) {
            try {
                gamificationContextEntityList.addAll(this.gamify(ruleDto, receiver.getId()));
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
        this.gamificationProcessor.process(gamificationContextEntityList);
    }

    public void ignored(RelationshipEvent event) {
    }

    public void removed(RelationshipEvent event) {
    }

    public void requested(RelationshipEvent event) {
    }

    public void denied(RelationshipEvent event) {
    }

    @Override
    public List<GamificationContextHolder> gamify(RuleDTO ruleDto, String actor) throws Exception {
        ArrayList<GamificationContextHolder> gamificationContextEntityList = new ArrayList<GamificationContextHolder>();
        GamificationContextHolder contextHolder = null;
        GamificationContextEntity gamificationContextEntity = null;
        if (ruleDto != null) {
            gamificationContextEntity = this.gamificationService.findGamificationContextByUsername(actor);
            contextHolder = new GamificationContextHolder();
            if (gamificationContextEntity != null) {
                String title = ruleDto.getTitle();
                Set<GamificationContextItemEntity> gamificationContextItemEntitySet = gamificationContextEntity.getGamificationItems().stream().filter(item -> item.getOpType().equalsIgnoreCase(title)).collect(Collectors.toSet());
                if (gamificationContextItemEntitySet != null && !gamificationContextItemEntitySet.isEmpty()) {
                    gamificationContextItemEntitySet.forEach(item -> {
                        item.setOccurrence(item.getOccurrence() + 1);
                        item.setScore(item.getScore() + ruleDto.getScore());
                    });
                    gamificationContextEntity.setScore(gamificationContextEntity.getScore() + (long)ruleDto.getScore());
                } else {
                    GamificationContextItemEntity gamificationContextItemEntity = new GamificationContextItemEntity();
                    gamificationContextItemEntity.setOpType(title);
                    gamificationContextItemEntity.setZone(ruleDto.getArea());
                    gamificationContextItemEntity.setOccurrence(1);
                    gamificationContextItemEntity.setScore(ruleDto.getScore());
                    gamificationContextEntity.setScore(gamificationContextEntity.getScore() + (long)ruleDto.getScore());
                    gamificationContextEntity.addGamificationItem(gamificationContextItemEntity);
                }
            } else {
                gamificationContextEntity = new GamificationContextEntity();
                gamificationContextEntity.setUsername(actor);
                gamificationContextEntity.setScore(ruleDto.getScore());
                GamificationContextItemEntity gamificationContextItemEntity = new GamificationContextItemEntity();
                gamificationContextItemEntity.setOccurrence(1);
                gamificationContextItemEntity.setOpType(ruleDto.getTitle());
                gamificationContextItemEntity.setZone(ruleDto.getArea());
                gamificationContextItemEntity.setScore(ruleDto.getScore());
                gamificationContextItemEntity.setGamificationUserEntity(gamificationContextEntity);
                gamificationContextEntity.getGamificationItems().add(gamificationContextItemEntity);
                contextHolder.setNew(true);
            }
            contextHolder.setGamificationContextEntity(gamificationContextEntity);
            gamificationContextEntityList.add(contextHolder);
        }
        return gamificationContextEntityList;
    }
}

