/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.forum;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextEntity;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextItemEntity;
import org.exoplatform.addons.gamification.listener.GamificationListener;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.dto.effective.GamificationContextHolder;
import org.exoplatform.addons.gamification.service.effective.GamificationProcessor;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumEventListener;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;

public class GamificationForumListener
extends ForumEventListener
implements GamificationListener {
    private static final Log LOG = ExoLogger.getLogger(GamificationForumListener.class);
    protected RuleService ruleService;
    protected GamificationProcessor gamificationProcessor;
    protected IdentityManager identityManager;
    protected SpaceService spaceService;
    protected GamificationService gamificationService;
    protected ActivityManager activityManager;
    protected ForumService forumService;

    public GamificationForumListener(RuleService ruleService, GamificationProcessor gamificationProcessor, IdentityManager identityManager, SpaceService spaceService, GamificationService gamificationService, ActivityManager activityManager, ForumService forumService) {
        this.ruleService = ruleService;
        this.gamificationProcessor = gamificationProcessor;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.gamificationService = gamificationService;
        this.activityManager = activityManager;
        this.forumService = forumService;
    }

    public void saveCategory(Category category) {
    }

    public void saveForum(Forum forum) {
    }

    public void addPost(Post post) {
        List<GamificationContextHolder> gamificationContextEntityList = null;
        RuleDTO ruleDto = null;
        ruleDto = this.ruleService.findEnableRuleByTitle("addForumPost");
        if (ruleDto != null) {
            try {
                gamificationContextEntityList = this.gamify(ruleDto, this.identityManager.getOrCreateIdentity("organization", post.getOwner(), false).getId());
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
        if (!gamificationContextEntityList.isEmpty()) {
            this.gamificationProcessor.process(gamificationContextEntityList);
        }
    }

    public void updatePost(Post post) {
    }

    public void updatePost(Post post, int type) {
    }

    public void addTopic(Topic topic) {
        List<GamificationContextHolder> gamificationContextEntityList = null;
        RuleDTO ruleDto = null;
        ruleDto = this.ruleService.findEnableRuleByTitle("addForumTopic");
        if (ruleDto != null) {
            try {
                gamificationContextEntityList = this.gamify(ruleDto, this.identityManager.getOrCreateIdentity("organization", topic.getOwner(), false).getId());
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
        if (!gamificationContextEntityList.isEmpty()) {
            this.gamificationProcessor.process(gamificationContextEntityList);
        }
    }

    public void updateTopic(Topic topic) {
    }

    public void updateTopics(List<Topic> topics, boolean isLock) {
    }

    public void moveTopic(Topic topic, String toCategoryName, String toForumName) {
    }

    public void mergeTopic(Topic newTopic, String removeActivityId1, String removeActivityId2) {
    }

    public void splitTopic(Topic newTopic, Topic splitedTopic, String removeActivityId) {
    }

    public void removeActivity(String activityId) {
    }

    public void removeComment(String activityId, String commentId) {
    }

    public void movePost(List<Post> list, List<String> list1, String s) {
    }

    @Override
    public List<GamificationContextHolder> gamify(RuleDTO ruleDto, String actor) throws Exception {
        ArrayList<GamificationContextHolder> gamificationContextEntityList = new ArrayList<GamificationContextHolder>();
        GamificationContextHolder contextHolder = null;
        GamificationContextEntity gamificationContextEntity = null;
        if (ruleDto != null) {
            gamificationContextEntity = this.gamificationService.findGamificationContextByUsername(actor);
            contextHolder = new GamificationContextHolder();
            if (gamificationContextEntity != null) {
                String title = ruleDto.getTitle();
                Set<GamificationContextItemEntity> gamificationContextItemEntitySet = gamificationContextEntity.getGamificationItems().stream().filter(item -> item.getOpType().equalsIgnoreCase(title)).collect(Collectors.toSet());
                if (gamificationContextItemEntitySet != null && !gamificationContextItemEntitySet.isEmpty()) {
                    gamificationContextItemEntitySet.forEach(item -> {
                        item.setOccurrence(item.getOccurrence() + 1);
                        item.setScore(item.getScore() + ruleDto.getScore());
                    });
                    gamificationContextEntity.setScore(gamificationContextEntity.getScore() + (long)ruleDto.getScore());
                } else {
                    GamificationContextItemEntity gamificationContextItemEntity = new GamificationContextItemEntity();
                    gamificationContextItemEntity.setOpType(title);
                    gamificationContextItemEntity.setZone(ruleDto.getArea());
                    gamificationContextItemEntity.setOccurrence(1);
                    gamificationContextItemEntity.setScore(ruleDto.getScore());
                    gamificationContextEntity.setScore(gamificationContextEntity.getScore() + (long)ruleDto.getScore());
                    gamificationContextEntity.addGamificationItem(gamificationContextItemEntity);
                }
            } else {
                gamificationContextEntity = new GamificationContextEntity();
                gamificationContextEntity.setUsername(actor);
                gamificationContextEntity.setScore(ruleDto.getScore());
                GamificationContextItemEntity gamificationContextItemEntity = new GamificationContextItemEntity();
                gamificationContextItemEntity.setOccurrence(1);
                gamificationContextItemEntity.setOpType(ruleDto.getTitle());
                gamificationContextItemEntity.setZone(ruleDto.getArea());
                gamificationContextItemEntity.setScore(ruleDto.getScore());
                gamificationContextItemEntity.setGamificationUserEntity(gamificationContextEntity);
                gamificationContextEntity.getGamificationItems().add(gamificationContextItemEntity);
                contextHolder.setNew(true);
            }
            contextHolder.setGamificationContextEntity(gamificationContextEntity);
            gamificationContextEntityList.add(contextHolder);
        }
        return gamificationContextEntityList;
    }
}

