/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextEntity;
import org.exoplatform.addons.gamification.rest.ManageBadgesEndpoint;
import org.exoplatform.addons.gamification.service.effective.GamificationSearch;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.addons.gamification.service.effective.Piechart;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;

@Path(value="/gamification/leaderboard")
@Produces(value={"application/json"})
@RolesAllowed(value={"users"})
public class LeaderboardEndpoint
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ManageBadgesEndpoint.class);
    private static final String BLACK_LISTED_USERS_GROUP = "/leaderboard-blacklist-users";
    private final CacheControl cacheControl = new CacheControl();
    protected IdentityManager identityManager = null;
    protected GamificationService gamificationService = null;
    protected RelationshipManager relationshipManager;
    private List<String> blackListedUsers;
    private OrganizationService organizationService;

    public LeaderboardEndpoint() {
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
        this.identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        this.gamificationService = (GamificationService)CommonsUtils.getService(GamificationService.class);
        this.relationshipManager = (RelationshipManager)CommonsUtils.getService(RelationshipManager.class);
        this.organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
    }

    @GET
    @Path(value="rank/all")
    public Response getAllLeadersByRank(@Context UriInfo uriInfo) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            GamificationSearch gamificationSearch = new GamificationSearch();
            ArrayList<LeaderboardInfo> leaderboardList = new ArrayList<LeaderboardInfo>();
            LeaderboardInfo leaderboardInfo = null;
            try {
                List<GamificationContextEntity> gamificationContextEntities = this.gamificationService.filter(gamificationSearch);
                if (gamificationContextEntities == null) {
                    return Response.ok(leaderboardList, (String)"application/json").cacheControl(this.cacheControl).build();
                }
                for (GamificationContextEntity game : gamificationContextEntities) {
                    this.populateBlackListedUsers();
                    Identity identity = this.identityManager.getIdentity(game.getUsername(), true);
                    if (this.isBlackListedUser(identity.getRemoteId())) continue;
                    leaderboardInfo = new LeaderboardInfo();
                    leaderboardInfo.setScore(game.getScore());
                    leaderboardInfo.setRemoteId(identity.getRemoteId());
                    leaderboardInfo.setFullname(identity.getProfile().getFullName());
                    leaderboardInfo.setAvatarUrl(identity.getProfile().getAvatarUrl());
                    leaderboardInfo.setProfileUrl(identity.getProfile().getUrl());
                    leaderboardList.add(leaderboardInfo);
                }
                return Response.ok(leaderboardList, (String)"application/json").cacheControl(this.cacheControl).build();
            }
            catch (Exception e) {
                LOG.error((Object)"Error building leaderboard ", (Throwable)e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error building leaderboard").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @GET
    @Path(value="filter")
    public Response filter(@Context UriInfo uriInfo, @QueryParam(value="category") String category, @QueryParam(value="network") String network) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            GamificationSearch gamificationSearch = new GamificationSearch();
            if (StringUtils.isNotBlank((CharSequence)category) && !category.equalsIgnoreCase("null")) {
                gamificationSearch.setDomain(category);
            }
            if (StringUtils.isNotBlank((CharSequence)network)) {
                gamificationSearch.setNetwork(network);
            }
            LeaderboardInfo leaderboardInfo = null;
            ArrayList<LeaderboardInfo> leaderboardInfos = null;
            List<GamificationContextEntity> gamificationContextEntities = this.gamificationService.filter(gamificationSearch);
            try {
                if (gamificationContextEntities != null && !gamificationContextEntities.isEmpty()) {
                    leaderboardInfos = new ArrayList<LeaderboardInfo>();
                    int max = 10 > gamificationContextEntities.size() ? gamificationContextEntities.size() : 10;
                    Identity identity = null;
                    Identity currentIdentity = this.identityManager.getOrCreateIdentity("organization", conversationState.getIdentity().getUserId(), false);
                    this.populateBlackListedUsers();
                    for (int i = 0; i < max; ++i) {
                        identity = this.identityManager.getIdentity(gamificationContextEntities.get(i).getUsername(), true);
                        if (this.isBlackListedUser(identity.getRemoteId())) continue;
                        leaderboardInfo = new LeaderboardInfo();
                        leaderboardInfo.setAvatarUrl(identity.getProfile().getAvatarUrl());
                        leaderboardInfo.setFullname(identity.getProfile().getFullName());
                        leaderboardInfo.setRemoteId(identity.getRemoteId());
                        leaderboardInfo.setProfileUrl(identity.getProfile().getUrl());
                        leaderboardInfo.setScore(gamificationContextEntities.get(i).getScore());
                        if (gamificationSearch.getNetwork().equalsIgnoreCase("my-connection")) {
                            if (!identity.getId().equalsIgnoreCase(currentIdentity.getId()) && !this.isInMyConnections(identity, currentIdentity)) continue;
                            leaderboardInfos.add(leaderboardInfo);
                            continue;
                        }
                        leaderboardInfos.add(leaderboardInfo);
                    }
                }
                return Response.ok(leaderboardInfos, (String)"application/json").cacheControl(this.cacheControl).build();
            }
            catch (Exception e) {
                LOG.error("Error filtering leaderbaord by Doamin : {} and by Network {} ", new Object[]{gamificationSearch.getDomain(), gamificationSearch.getNetwork(), e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error filtering leaderboard").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @GET
    @Path(value="stats")
    public Response stats(@Context UriInfo uriInfo, @QueryParam(value="username") String username) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            try {
                String userSocialId = null;
                if (username != null) {
                    userSocialId = this.identityManager.getOrCreateIdentity("organization", username, false).getId();
                }
                List<Piechart> pieChart = this.gamificationService.findStatsByUserId(userSocialId);
                return Response.ok(pieChart, (String)"application/json").cacheControl(this.cacheControl).build();
            }
            catch (Exception e) {
                LOG.error("Error building statistics for user {} ", new Object[]{username, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error building statistics").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    private boolean isInMyConnections(Identity gameficationIdentity, Identity myIdentity) {
        Relationship gamificationRelationship = this.relationshipManager.get(myIdentity, gameficationIdentity);
        if (gamificationRelationship == null) {
            return false;
        }
        return gamificationRelationship.getStatus().name().equalsIgnoreCase(Relationship.Type.CONFIRMED.name());
    }

    private void populateBlackListedUsers() {
        try {
            this.blackListedUsers = new ArrayList<String>();
            ListAccess usersBlackList = this.organizationService.getUserHandler().findUsersByGroupId(BLACK_LISTED_USERS_GROUP);
            if (null != usersBlackList && usersBlackList.getSize() > 0) {
                User[] managerUser;
                for (User user : managerUser = (User[])usersBlackList.load(0, usersBlackList.getSize())) {
                    try {
                        this.blackListedUsers.add(user.getUserName());
                    }
                    catch (Exception e) {
                        LOG.error((Object)e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exceptions in initListUserToDisconnect", (Throwable)e);
        }
    }

    private boolean isBlackListedUser(String username) {
        if (this.blackListedUsers == null) {
            return false;
        }
        return this.blackListedUsers.contains(username);
    }

    public static class LeaderboardInfo {
        String avatarUrl;
        String remoteId;
        String fullname;
        long score;
        String profileUrl;

        public String getAvatarUrl() {
            return this.avatarUrl;
        }

        public void setAvatarUrl(String avatarUrl) {
            this.avatarUrl = avatarUrl;
        }

        public String getRemoteId() {
            return this.remoteId;
        }

        public void setRemoteId(String remoteId) {
            this.remoteId = remoteId;
        }

        public String getFullname() {
            return this.fullname;
        }

        public void setFullname(String fullname) {
            this.fullname = fullname;
        }

        public long getScore() {
            return this.score;
        }

        public void setScore(long score) {
            this.score = score;
        }

        public String getProfileUrl() {
            return this.profileUrl;
        }

        public void setProfileUrl(String profileUrl) {
            this.profileUrl = profileUrl;
        }
    }
}

