/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.wiki;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextEntity;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextItemEntity;
import org.exoplatform.addons.gamification.listener.GamificationListener;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.dto.effective.GamificationContextHolder;
import org.exoplatform.addons.gamification.service.effective.GamificationProcessor;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.listener.PageWikiListener;

@Asynchronous
public class GamificationWikiListener
extends PageWikiListener
implements GamificationListener {
    private static final Log LOG = ExoLogger.getLogger(GamificationWikiListener.class);
    protected RuleService ruleService;
    protected GamificationProcessor gamificationProcessor;
    protected IdentityManager identityManager;
    protected GamificationService gamificationService;

    public GamificationWikiListener(RuleService ruleService, GamificationProcessor gamificationProcessor, IdentityManager identityManager, GamificationService gamificationService) {
        this.ruleService = ruleService;
        this.gamificationProcessor = gamificationProcessor;
        this.identityManager = identityManager;
        this.gamificationService = gamificationService;
    }

    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        if ("WikiHome".equals(pageId)) {
            return;
        }
        List<GamificationContextHolder> gamificationContextEntityList = null;
        String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
        String actorId = this.identityManager.getOrCreateIdentity("organization", actorUsername, false).getId();
        RuleDTO ruleDto = this.ruleService.findEnableRuleByTitle("addWikiPage");
        if (ruleDto != null) {
            try {
                gamificationContextEntityList = this.gamify(ruleDto, actorId);
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
        this.gamificationProcessor.process(gamificationContextEntityList);
    }

    public void postDeletePage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
    }

    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page, PageUpdateType wikiUpdateType) throws WikiException {
        if (page != null && wikiUpdateType != null && (wikiUpdateType.equals((Object)PageUpdateType.ADD_PAGE) || wikiUpdateType.equals((Object)PageUpdateType.EDIT_PAGE_CONTENT) || wikiUpdateType.equals((Object)PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE))) {
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            List<GamificationContextHolder> gamificationContextEntityList = null;
            String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
            String actorId = this.identityManager.getOrCreateIdentity("organization", actorUsername, false).getId();
            RuleDTO ruleDto = this.ruleService.findEnableRuleByTitle("updateWikiPage");
            if (ruleDto != null) {
                try {
                    gamificationContextEntityList = this.gamify(ruleDto, actorId);
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
            this.gamificationProcessor.process(gamificationContextEntityList);
        }
    }

    @Override
    public List<GamificationContextHolder> gamify(RuleDTO ruleDto, String actor) throws Exception {
        ArrayList<GamificationContextHolder> gamificationContextEntityList = new ArrayList<GamificationContextHolder>();
        GamificationContextHolder contextHolder = null;
        GamificationContextEntity gamificationContextEntity = null;
        if (ruleDto != null) {
            gamificationContextEntity = this.gamificationService.findGamificationContextByUsername(actor);
            contextHolder = new GamificationContextHolder();
            if (gamificationContextEntity != null) {
                String title = ruleDto.getTitle();
                Set<GamificationContextItemEntity> gamificationContextItemEntitySet = gamificationContextEntity.getGamificationItems().stream().filter(item -> item.getOpType().equalsIgnoreCase(title)).collect(Collectors.toSet());
                if (gamificationContextItemEntitySet != null && !gamificationContextItemEntitySet.isEmpty()) {
                    gamificationContextItemEntitySet.forEach(item -> {
                        item.setOccurrence(item.getOccurrence() + 1);
                        item.setScore(item.getScore() + ruleDto.getScore());
                    });
                    gamificationContextEntity.setScore(gamificationContextEntity.getScore() + (long)ruleDto.getScore());
                } else {
                    GamificationContextItemEntity gamificationContextItemEntity = new GamificationContextItemEntity();
                    gamificationContextItemEntity.setOpType(title);
                    gamificationContextItemEntity.setZone(ruleDto.getArea());
                    gamificationContextItemEntity.setOccurrence(1);
                    gamificationContextItemEntity.setScore(ruleDto.getScore());
                    gamificationContextEntity.setScore(gamificationContextEntity.getScore() + (long)ruleDto.getScore());
                    gamificationContextEntity.addGamificationItem(gamificationContextItemEntity);
                }
            } else {
                gamificationContextEntity = new GamificationContextEntity();
                gamificationContextEntity.setUsername(actor);
                gamificationContextEntity.setScore(ruleDto.getScore());
                GamificationContextItemEntity gamificationContextItemEntity = new GamificationContextItemEntity();
                gamificationContextItemEntity.setOccurrence(1);
                gamificationContextItemEntity.setOpType(ruleDto.getTitle());
                gamificationContextItemEntity.setZone(ruleDto.getArea());
                gamificationContextItemEntity.setScore(ruleDto.getScore());
                gamificationContextEntity.setScore(ruleDto.getScore());
                gamificationContextItemEntity.setGamificationUserEntity(gamificationContextEntity);
                gamificationContextEntity.getGamificationItems().add(gamificationContextItemEntity);
                contextHolder.setNew(true);
            }
            contextHolder.setGamificationContextEntity(gamificationContextEntity);
            gamificationContextEntityList.add(contextHolder);
        }
        return gamificationContextEntityList;
    }
}

