/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextEntity;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextItemEntity;
import org.exoplatform.addons.gamification.rest.ManageRulesEndpoint;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/gamification/purge")
@Produces(value={"application/json"})
@RolesAllowed(value={"administrators"})
public class PurgeGamificationDataEndPoint
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ManageRulesEndpoint.class);
    private final CacheControl cacheControl = new CacheControl();
    protected GamificationService gamificationService = null;

    public PurgeGamificationDataEndPoint(GamificationService gamificationService) {
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
        this.gamificationService = gamificationService;
    }

    @GET
    @Path(value="items")
    public Response purge(@Context UriInfo uriInfo, @QueryParam(value="id") String id, @QueryParam(value="domain") String domain) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            List<GamificationContextItemEntity> gamificationContextItemEntityList = null;
            try {
                gamificationContextItemEntityList = this.gamificationService.findGamificationItemsByUserIdAndDomain(id, domain);
                if (gamificationContextItemEntityList != null && !gamificationContextItemEntityList.isEmpty()) {
                    LOG.info("Gamification items for user {} in Domain {} are {} ", new Object[]{id, domain, gamificationContextItemEntityList.size()});
                    ArrayList<String> opType = new ArrayList<String>();
                    for (GamificationContextItemEntity item : gamificationContextItemEntityList) {
                        if (!opType.contains(item.getOpType())) {
                            opType.add(item.getOpType());
                            continue;
                        }
                        this.gamificationService.deleteItem(item);
                    }
                }
                return Response.ok((Object)"Done", (String)"application/json").cacheControl(this.cacheControl).build();
            }
            catch (Exception e) {
                LOG.error("Error puging Gamification Items for userid {} ", new Object[]{id, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error filtering leaderboard").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @GET
    @Path(value="score")
    public Response update(@Context UriInfo uriInfo, @QueryParam(value="id") String id) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            try {
                Set<GamificationContextItemEntity> items;
                GamificationContextEntity gamificationContextEntity = this.gamificationService.findGamificationContextByUsername(id);
                if (gamificationContextEntity != null && (items = gamificationContextEntity.getGamificationItems()) != null && !items.isEmpty()) {
                    ArrayList<String> opType = new ArrayList<String>();
                    int scoreSocial = 0;
                    int scoreKnowledge = 0;
                    for (GamificationContextItemEntity item : items) {
                        if (item.getZone().equalsIgnoreCase("social")) {
                            if (!opType.contains(item.getOpType())) {
                                scoreKnowledge += item.getScore();
                            }
                        } else if (!opType.contains(item.getOpType())) {
                            scoreKnowledge += item.getScore();
                        }
                        opType.add(item.getOpType());
                    }
                    if ((long)(scoreSocial + scoreKnowledge) > gamificationContextEntity.getScore()) {
                        gamificationContextEntity.setScore(scoreSocial + scoreKnowledge);
                        this.gamificationService.updateUserGamificationContextScore(gamificationContextEntity);
                    }
                }
                return Response.ok((Object)"Done", (String)"application/json").cacheControl(this.cacheControl).build();
            }
            catch (Exception e) {
                LOG.error("Error puging Gamification Items for userid {} ", new Object[]{id, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error filtering leaderboard").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }
}

