/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.GamificationUtils;
import org.exoplatform.addons.gamification.rest.LeaderboardEndpoint;
import org.exoplatform.addons.gamification.rest.ManageBadgesEndpoint;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.addons.gamification.service.effective.LeaderboardFilter;
import org.exoplatform.addons.gamification.service.effective.StandardLeaderboard;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

@Path(value="/gamification/space/leaderboard")
@Produces(value={"application/json"})
@RolesAllowed(value={"users"})
public class SpaceLeaderboardEndpoint
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ManageBadgesEndpoint.class);
    private final CacheControl cacheControl = new CacheControl();
    protected GamificationService gamificationService = null;
    protected IdentityManager identityManager = null;
    protected SpaceService spaceService = null;

    public SpaceLeaderboardEndpoint(GamificationService gamificationService, IdentityManager identityManager, SpaceService spaceService) {
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
        this.gamificationService = gamificationService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
    }

    @GET
    @Path(value="overall")
    public Response getAllLeadersByRank(@Context UriInfo uriInfo, @QueryParam(value="url") String url) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            LeaderboardFilter leaderboardFilter = new LeaderboardFilter();
            ArrayList<LeaderboardEndpoint.LeaderboardInfo> leaderboardList = new ArrayList<LeaderboardEndpoint.LeaderboardInfo>();
            LeaderboardEndpoint.LeaderboardInfo leaderboardInfo = null;
            Identity identity = null;
            try {
                Space space = GamificationUtils.extractSpaceNameFromUrl(url);
                List<StandardLeaderboard> standardLeaderboards = this.gamificationService.filter(leaderboardFilter, false);
                if (standardLeaderboards == null) {
                    return Response.ok(leaderboardList, (String)"application/json").cacheControl(this.cacheControl).build();
                }
                for (StandardLeaderboard element : standardLeaderboards) {
                    identity = this.identityManager.getIdentity(element.getUserSocialId(), true);
                    if (this.spaceService.isMember(space, identity.getRemoteId())) {
                        leaderboardInfo = new LeaderboardEndpoint.LeaderboardInfo();
                        leaderboardInfo.setSocialId(identity.getId());
                        leaderboardInfo.setScore(element.getReputationScore());
                        leaderboardInfo.setRemoteId(identity.getRemoteId());
                        leaderboardInfo.setFullname(identity.getProfile().getFullName());
                        leaderboardInfo.setAvatarUrl(identity.getProfile().getAvatarUrl());
                        leaderboardInfo.setProfileUrl(identity.getProfile().getUrl());
                        leaderboardList.add(leaderboardInfo);
                    }
                    if (leaderboardList.size() != 10) continue;
                    return Response.ok(leaderboardList, (String)"application/json").cacheControl(this.cacheControl).build();
                }
                return Response.ok(leaderboardList, (String)"application/json").cacheControl(this.cacheControl).build();
            }
            catch (Exception e) {
                LOG.error((Object)"Error building leaderboard ", (Throwable)e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error building leaderboard").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @GET
    @Path(value="filter")
    public Response filter(@Context UriInfo uriInfo, @QueryParam(value="domain") String domain, @QueryParam(value="period") String period, @QueryParam(value="url") String url) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            LeaderboardFilter leaderboardFilter = new LeaderboardFilter();
            if (StringUtils.isNotBlank((CharSequence)domain) && !domain.equalsIgnoreCase("null")) {
                leaderboardFilter.setDomain(domain);
            }
            if (StringUtils.isNotBlank((CharSequence)period)) {
                leaderboardFilter.setPeriod(period);
            }
            LeaderboardEndpoint.LeaderboardInfo leaderboardInfo = null;
            ArrayList<LeaderboardEndpoint.LeaderboardInfo> leaderboardInfoList = null;
            try {
                Space space = GamificationUtils.extractSpaceNameFromUrl(url);
                List<StandardLeaderboard> standardLeaderboards = this.gamificationService.filter(leaderboardFilter, false);
                if (standardLeaderboards == null) {
                    return Response.ok(leaderboardInfoList, (String)"application/json").cacheControl(this.cacheControl).build();
                }
                leaderboardInfoList = new ArrayList<LeaderboardEndpoint.LeaderboardInfo>();
                Identity identity = null;
                Identity currentIdentity = this.identityManager.getOrCreateIdentity("organization", conversationState.getIdentity().getUserId(), false);
                for (StandardLeaderboard leader : standardLeaderboards) {
                    identity = this.identityManager.getIdentity(leader.getUserSocialId(), true);
                    if (this.spaceService.isMember(space, identity.getRemoteId())) {
                        leaderboardInfo = new LeaderboardEndpoint.LeaderboardInfo();
                        leaderboardInfo.setSocialId(identity.getId());
                        leaderboardInfo.setScore(leader.getReputationScore());
                        leaderboardInfo.setRemoteId(identity.getRemoteId());
                        leaderboardInfo.setFullname(identity.getProfile().getFullName());
                        leaderboardInfo.setAvatarUrl(identity.getProfile().getAvatarUrl());
                        leaderboardInfo.setProfileUrl(identity.getProfile().getUrl());
                        leaderboardInfoList.add(leaderboardInfo);
                    }
                    if (leaderboardInfoList.size() != 10) continue;
                    return Response.ok(leaderboardInfoList, (String)"application/json").cacheControl(this.cacheControl).build();
                }
                return Response.ok(leaderboardInfoList, (String)"application/json").cacheControl(this.cacheControl).build();
            }
            catch (Exception e) {
                LOG.error("Error filtering leaderbaord by Doamin : {} and by Period {} ", new Object[]{leaderboardFilter.getDomain(), leaderboardFilter.getPeriod(), e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error filtering leaderboard").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }
}

