/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.entities.domain.effective;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.exoplatform.addons.gamification.entities.domain.configuration.AbstractAuditingEntity;
import org.exoplatform.commons.api.persistence.ExoEntity;

@ExoEntity
@Entity(name="GamificationActionsHistory")
@Table(name="GAMIFICATION_ACTIONS_HISTORY")
@NamedQueries(value={@NamedQuery(name="GamificationActionsHistory.findAllActionsHistory", query="SELECT new org.exoplatform.addons.gamification.service.effective.StandardLeaderboard(g.userSocialId, SUM(g.actionScore) as total) FROM GamificationActionsHistory g GROUP BY g.userSocialId ORDER BY total DESC"), @NamedQuery(name="GamificationActionsHistory.findAllActionsHistoryByDateByDomain", query="SELECT new org.exoplatform.addons.gamification.service.effective.StandardLeaderboard(g.userSocialId, SUM(g.actionScore) as total) FROM GamificationActionsHistory g  WHERE g.date >= :date AND g.domain = :domain GROUP BY g.userSocialId ORDER BY total DESC"), @NamedQuery(name="GamificationActionsHistory.findActionsHistoryByUserId", query="SELECT a FROM GamificationActionsHistory a where a.userSocialId = :socialUserId ORDER BY a.globalScore DESC"), @NamedQuery(name="GamificationActionsHistory.findAllActionsHistoryByDomain", query="SELECT new org.exoplatform.addons.gamification.service.effective.StandardLeaderboard(g.userSocialId, SUM(g.actionScore) as total) FROM GamificationActionsHistory g WHERE g.domain = :domain GROUP BY g.userSocialId ORDER BY total DESC"), @NamedQuery(name="GamificationActionsHistory.findActionHistoryByDateBySocialId", query="SELECT a FROM GamificationActionsHistory a where a.date = :date and a.userSocialId = :socialId ORDER BY a.globalScore DESC"), @NamedQuery(name="GamificationActionsHistory.findActionsHistoryByDate", query="SELECT new org.exoplatform.addons.gamification.service.effective.StandardLeaderboard(g.userSocialId, SUM(g.actionScore) as total) FROM GamificationActionsHistory g WHERE g.date >= :date GROUP BY g.userSocialId ORDER BY total DESC"), @NamedQuery(name="GamificationActionsHistory.findActionsHistoryByDateByDomain", query="SELECT new org.exoplatform.addons.gamification.service.effective.StandardLeaderboard(g.userSocialId, SUM(g.actionScore) as total) FROM GamificationActionsHistory g WHERE g.date >= :date and g.domain = :domain GROUP BY g.userSocialId ORDER BY total DESC"), @NamedQuery(name="GamificationActionsHistory.findStatsByUser", query="SELECT new org.exoplatform.addons.gamification.service.effective.PiechartLeaderboard(g.domain,SUM(g.actionScore)) FROM GamificationActionsHistory g WHERE g.userSocialId = :userSocialId GROUP BY g.domain"), @NamedQuery(name="GamificationActionsHistory.findDomainScoreByUserId", query="SELECT new org.exoplatform.addons.gamification.service.effective.ProfileReputation(g.domain,SUM(g.actionScore)) FROM GamificationActionsHistory g WHERE g.userSocialId = :userSocialId GROUP BY g.domain"), @NamedQuery(name="GamificationActionsHistory.findUserReputationScoreBetweenDate", query="SELECT SUM(g.actionScore) as total FROM GamificationActionsHistory g WHERE g.userSocialId = :userSocialId AND g.date BETWEEN :fromDate AND :toDate"), @NamedQuery(name="GamificationActionsHistory.findUserReputationScoreByDomainBetweenDate", query="SELECT SUM(g.actionScore) as total FROM GamificationActionsHistory g WHERE g.userSocialId = :userSocialId AND g.domain = :domain AND g.date BETWEEN :fromDate AND :toDate")})
public class GamificationActionsHistory
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name="SEQ_GAMIFICATION_ACTIONS_HISTORY_ID", sequenceName="SEQ_GAMIFICATION_ACTIONS_HISTORY_ID")
    @GeneratedValue(strategy=GenerationType.IDENTITY, generator="SEQ_GAMIFICATION_ACTIONS_HISTORY_ID")
    @Column(name="ID")
    protected Long id;
    @Temporal(value=TemporalType.DATE)
    @Column(name="ACTION_DATE")
    private Date date;
    @Column(name="USER_SOCIAL_ID", nullable=false)
    private String userSocialId;
    @Column(name="GLOBAL_SCORE", nullable=false)
    protected long globalScore;
    @Column(name="ACTION_TITLE", nullable=false)
    private String actionTitle;
    @Column(name="DOMAIN", nullable=false)
    private String domain;
    @Column(name="CONTEXT", nullable=true)
    private String context;
    @Column(name="ACTION_SCORE", nullable=false)
    private long actionScore;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getUserSocialId() {
        return this.userSocialId;
    }

    public void setUserSocialId(String userSocialId) {
        this.userSocialId = userSocialId;
    }

    public long getGlobalScore() {
        return this.globalScore;
    }

    public void setGlobalScore(long globalScore) {
        this.globalScore = globalScore;
    }

    public String getActionTitle() {
        return this.actionTitle;
    }

    public void setActionTitle(String actionTitle) {
        this.actionTitle = actionTitle;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public long getActionScore() {
        return this.actionScore;
    }

    public void setActionScore(long actionScore) {
        this.actionScore = actionScore;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GamificationActionsHistory)) {
            return false;
        }
        GamificationActionsHistory that = (GamificationActionsHistory)obj;
        EqualsBuilder eb = new EqualsBuilder();
        eb.append((Object)this.date, (Object)that.date);
        eb.append((Object)this.userSocialId, (Object)that.userSocialId);
        eb.append(this.globalScore, that.globalScore);
        eb.append((Object)this.actionTitle, (Object)that.actionTitle);
        eb.append((Object)this.domain, (Object)that.domain);
        eb.append((Object)this.context, (Object)that.context);
        eb.append(this.actionScore, that.actionScore);
        return eb.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append((Object)this.date);
        hcb.append((Object)this.userSocialId);
        hcb.append(this.globalScore);
        hcb.append((Object)this.actionTitle);
        hcb.append((Object)this.domain);
        hcb.append(this.actionScore);
        return hcb.toHashCode();
    }

    public String toString() {
        return "Gamification History{date=" + this.date + ", social_id=" + this.userSocialId + ", global_score=" + this.globalScore + ", action_title=" + this.actionTitle + ", domain=" + this.domain + ", context=" + this.context + ", action_score=" + this.actionScore + '}';
    }
}

