/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.wiki;

import java.time.LocalDate;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.listener.GamificationListener;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.effective.GamificationProcessor;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.listener.PageWikiListener;

@Asynchronous
public class GamificationWikiListener
extends PageWikiListener
implements GamificationListener {
    private static final Log LOG = ExoLogger.getLogger(GamificationWikiListener.class);
    protected RuleService ruleService;
    protected GamificationProcessor gamificationProcessor;
    protected IdentityManager identityManager;
    protected GamificationService gamificationService;

    public GamificationWikiListener(RuleService ruleService, GamificationProcessor gamificationProcessor, IdentityManager identityManager, GamificationService gamificationService) {
        this.ruleService = ruleService;
        this.gamificationProcessor = gamificationProcessor;
        this.identityManager = identityManager;
        this.gamificationService = gamificationService;
    }

    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        if ("WikiHome".equals(pageId)) {
            return;
        }
        GamificationActionsHistory aHistory = null;
        String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
        String actorId = this.identityManager.getOrCreateIdentity("organization", actorUsername, false).getId();
        RuleDTO ruleDto = this.ruleService.findEnableRuleByTitle("addWikiPage");
        if (ruleDto != null) {
            try {
                aHistory = this.build(ruleDto, actorId);
                this.gamificationProcessor.execute(aHistory);
                LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), actorId, aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
            }
            catch (Exception e) {
                LOG.error("Error processing the following ActionHistory entry {}", new Object[]{aHistory, e});
            }
        }
    }

    public void postDeletePage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
    }

    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page, PageUpdateType wikiUpdateType) throws WikiException {
        if (page != null && wikiUpdateType != null && (wikiUpdateType.equals((Object)PageUpdateType.ADD_PAGE) || wikiUpdateType.equals((Object)PageUpdateType.EDIT_PAGE_CONTENT) || wikiUpdateType.equals((Object)PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE))) {
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            GamificationActionsHistory aHistory = null;
            String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
            String actorId = this.identityManager.getOrCreateIdentity("organization", actorUsername, false).getId();
            RuleDTO ruleDto = this.ruleService.findEnableRuleByTitle("updateWikiPage");
            if (ruleDto != null) {
                try {
                    aHistory = this.build(ruleDto, actorId);
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), actorId, aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error processing the following ActionHistory entry {}", new Object[]{aHistory, e});
                }
            }
        }
    }
}

