/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.social.relationship;

import java.time.LocalDate;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.effective.GamificationProcessor;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.relationship.RelationshipEvent;
import org.exoplatform.social.core.relationship.RelationshipListenerPlugin;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.spi.SpaceService;

@Asynchronous
public class GamificationRelationshipListener
extends RelationshipListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(GamificationRelationshipListener.class);
    protected RuleService ruleService = (RuleService)CommonsUtils.getService(RuleService.class);
    protected GamificationProcessor gamificationProcessor = (GamificationProcessor)CommonsUtils.getService(GamificationProcessor.class);
    protected IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
    protected SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
    protected GamificationService gamificationService = (GamificationService)CommonsUtils.getService(GamificationService.class);

    public void confirmed(RelationshipEvent event) {
        GamificationActionsHistory aHistory = null;
        Identity sender = ((Relationship)event.getPayload()).getSender();
        Identity receiver = ((Relationship)event.getPayload()).getReceiver();
        RuleDTO ruleDto = null;
        ruleDto = this.ruleService.findEnableRuleByTitle("sendRelationshipRequest");
        if (ruleDto != null) {
            try {
                aHistory = this.gamificationService.build(ruleDto, receiver.getId(), sender.getId(), "/portal/intranet/profile/" + receiver.getRemoteId());
                this.gamificationProcessor.execute(aHistory);
                LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
        if ((ruleDto = this.ruleService.findEnableRuleByTitle("receiveRelationshipRequest")) != null) {
            try {
                aHistory = this.gamificationService.build(ruleDto, sender.getId(), receiver.getId(), "/portal/intranet/profile/" + sender.getRemoteId());
                this.gamificationProcessor.execute(aHistory);
                LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
    }

    public void ignored(RelationshipEvent event) {
    }

    public void removed(RelationshipEvent event) {
    }

    public void requested(RelationshipEvent event) {
    }

    public void denied(RelationshipEvent event) {
    }
}

