/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.mapper;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.exoplatform.addons.gamification.entities.domain.configuration.DomainEntity;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DomainMapper {
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private static final Log LOG = ExoLogger.getLogger(DomainMapper.class);

    public DomainDTO domainToDomainDTO(DomainEntity domain) {
        return new DomainDTO(domain);
    }

    public List<DomainDTO> domainssToDomainDTOs(List<DomainEntity> domains) {
        return domains.stream().filter(Objects::nonNull).map(domain -> this.domainToDomainDTO((DomainEntity)domain)).collect(Collectors.toList());
    }

    public DomainEntity domainDTOToDomain(DomainDTO domainDTO) {
        if (domainDTO == null) {
            return null;
        }
        DomainEntity domain = new DomainEntity();
        domain.setId(domainDTO.getId());
        domain.setTitle(domainDTO.getTitle());
        domain.setDescription(domainDTO.getDescription());
        domain.setCreatedBy(domainDTO.getCreatedBy());
        domain.setLastModifiedBy(domainDTO.getLastModifiedBy());
        if (domainDTO.getLastModifiedDate() != null) {
            try {
                domain.setLastModifiedDate(formatter.parse(domainDTO.getLastModifiedDate()));
            }
            catch (ParseException e) {
                LOG.warn("Cannot parse the domain {} last modified date", new Object[]{domain.getId(), e});
            }
        }
        return domain;
    }

    public List<DomainEntity> domainDTOsToDomains(List<DomainDTO> domainDTOs) {
        return domainDTOs.stream().filter(Objects::nonNull).map(domainDTO -> this.domainDTOToDomain((DomainDTO)domainDTO)).collect(Collectors.toList());
    }

    public DomainEntity domainFromId(Long id) {
        if (id == null) {
            return null;
        }
        DomainEntity domain = new DomainEntity();
        domain.setId(id);
        return domain;
    }
}

