/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.dto.configuration;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import org.exoplatform.addons.gamification.entities.domain.configuration.BadgeEntity;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO;

public class BadgeDTO
implements Serializable {
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    protected Long id;
    protected String title;
    protected String description;
    protected int neededScore;
    protected String domain;
    private DomainDTO domainDTO;
    private byte[] icon;
    protected String startValidityDate;
    protected String endValidityDate;
    protected boolean enabled;
    private String createdBy;
    private String createdDate;
    private String lastModifiedBy;
    private String lastModifiedDate;
    private long iconFileId;
    private String uploadId;

    public BadgeDTO() {
    }

    public BadgeDTO(BadgeEntity badgeEntity) {
        this.id = badgeEntity.getId();
        this.title = badgeEntity.getTitle();
        this.neededScore = badgeEntity.getNeededScore();
        if (badgeEntity.getStartValidityDate() != null) {
            this.startValidityDate = formatter.format(badgeEntity.getStartValidityDate());
        }
        if (badgeEntity.getEndValidityDate() != null) {
            this.endValidityDate = formatter.format(badgeEntity.getEndValidityDate());
        }
        this.enabled = badgeEntity.isEnabled();
        this.description = badgeEntity.getDescription();
        this.createdBy = badgeEntity.getCreatedBy();
        if (badgeEntity.getCreatedDate() != null) {
            this.createdDate = formatter.format(badgeEntity.getCreatedDate());
        }
        this.lastModifiedBy = badgeEntity.getLastModifiedBy();
        if (badgeEntity.getLastModifiedDate() != null) {
            this.lastModifiedDate = formatter.format(badgeEntity.getLastModifiedDate());
        }
        this.domain = badgeEntity.getDomain();
        this.domainDTO = badgeEntity.getDomainEntity() == null ? null : new DomainDTO(badgeEntity.getDomainEntity());
        this.iconFileId = badgeEntity.getIconFileId();
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getNeededScore() {
        return this.neededScore;
    }

    public void setNeededScore(int neededScore) {
        this.neededScore = neededScore;
    }

    public byte[] getIcon() {
        return this.icon;
    }

    public void setIcon(byte[] icon) {
        this.icon = icon;
    }

    public long getIconFileId() {
        return this.iconFileId;
    }

    public void setIconFileId(long iconFileId) {
        this.iconFileId = iconFileId;
    }

    public String getStartValidityDate() {
        return this.startValidityDate;
    }

    public void setStartValidityDate(String startValidityDate) {
        this.startValidityDate = startValidityDate;
    }

    public String getEndValidityDate() {
        return this.endValidityDate;
    }

    public void setEndValidityDate(String endValidityDate) {
        this.endValidityDate = endValidityDate;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(String createdDate) {
        this.createdDate = createdDate;
    }

    public String getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(String lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public String getDomain() {
        if (this.domainDTO != null) {
            return this.domainDTO.getTitle();
        }
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public DomainDTO getDomainDTO() {
        return this.domainDTO;
    }

    public void setDomainDTO(DomainDTO domainDTO) {
        this.domainDTO = domainDTO;
    }

    public String toString() {
        return "BadgeDTO{title='" + this.title + '\'' + ", neededScore='" + this.neededScore + '\'' + ", startValidityDate='" + this.startValidityDate + '\'' + ", endValidityDate='" + this.endValidityDate + '\'' + ", description='" + this.description + '\'' + ", icon='" + this.icon + '\'' + ", zone='" + this.domain + '\'' + ", createdBy=" + this.createdBy + ", createdDate=" + this.createdDate + ", lastModifiedBy='" + this.lastModifiedBy + '\'' + ", lastModifiedDate=" + this.lastModifiedDate + "}";
    }
}

