/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.configuration;

import java.util.List;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.addons.gamification.entities.domain.configuration.DomainEntity;
import org.exoplatform.addons.gamification.service.configuration.DomainService$AjcClosure1;
import org.exoplatform.addons.gamification.service.configuration.DomainService$AjcClosure3;
import org.exoplatform.addons.gamification.service.configuration.DomainService$AjcClosure5;
import org.exoplatform.addons.gamification.service.configuration.DomainService$AjcClosure7;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO;
import org.exoplatform.addons.gamification.service.mapper.DomainMapper;
import org.exoplatform.addons.gamification.storage.dao.DomainDAO;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DomainService {
    private static final Log LOG;
    protected final DomainDAO domainStorage;
    protected final DomainMapper domainMapper;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public DomainService(DomainDAO domainDAO, DomainMapper domainMapper) {
        this.domainStorage = domainDAO;
        this.domainMapper = domainMapper;
    }

    public DomainService() {
        this.domainStorage = (DomainDAO)((Object)CommonsUtils.getService(DomainDAO.class));
        this.domainMapper = (DomainMapper)CommonsUtils.getService(DomainMapper.class);
    }

    public List<DomainDTO> getAllDomains() {
        try {
            List badges = this.domainStorage.findAll();
            if (badges != null) {
                return this.domainMapper.domainssToDomainDTOs(badges);
            }
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)"Error to find Domains", (Throwable)e);
            throw e;
        }
    }

    @ExoTransactional
    public DomainDTO findDomainByTitle(String domainTitle) {
        String string = domainTitle;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (DomainDTO)ExoTransactionalAspect.aspectOf().around(new DomainService$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public DomainDTO addDomain(DomainDTO domainDTO) throws PersistenceException {
        DomainDTO domainDTO2 = domainDTO;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)domainDTO2);
        Object[] objectArray = new Object[]{this, domainDTO2, joinPoint};
        return (DomainDTO)ExoTransactionalAspect.aspectOf().around(new DomainService$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public DomainDTO updateDomain(DomainDTO domainDTO) throws PersistenceException {
        DomainDTO domainDTO2 = domainDTO;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)domainDTO2);
        Object[] objectArray = new Object[]{this, domainDTO2, joinPoint};
        return (DomainDTO)ExoTransactionalAspect.aspectOf().around(new DomainService$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void deleteDomain(Long id) throws EntityNotFoundException {
        Long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)l);
        Object[] objectArray = new Object[]{this, l, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new DomainService$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    static {
        DomainService.ajc$preClinit();
        LOG = ExoLogger.getLogger(DomainService.class);
    }

    static /* synthetic */ DomainDTO findDomainByTitle_aroundBody0(DomainService ajc$this, String domainTitle, JoinPoint joinPoint) {
        try {
            DomainEntity entity = ajc$this.domainStorage.findDomainByTitle(domainTitle);
            if (entity != null) {
                return ajc$this.domainMapper.domainToDomainDTO(entity);
            }
            return null;
        }
        catch (Exception e) {
            LOG.error("Error to find Domain entity with title : {}", new Object[]{domainTitle, e});
            throw e;
        }
    }

    static /* synthetic */ DomainDTO addDomain_aroundBody2(DomainService ajc$this, DomainDTO domainDTO, JoinPoint joinPoint) {
        DomainEntity domainEntity = null;
        try {
            domainEntity = (DomainEntity)ajc$this.domainStorage.create(ajc$this.domainMapper.domainDTOToDomain(domainDTO));
            return ajc$this.domainMapper.domainToDomainDTO(domainEntity);
        }
        catch (Exception e) {
            LOG.error("Error to create badge with title {}", new Object[]{domainDTO.getTitle(), e});
            throw e;
        }
    }

    static /* synthetic */ DomainDTO updateDomain_aroundBody4(DomainService ajc$this, DomainDTO domainDTO, JoinPoint joinPoint) {
        DomainEntity domainEntity = null;
        try {
            domainEntity = (DomainEntity)ajc$this.domainStorage.update(ajc$this.domainMapper.domainDTOToDomain(domainDTO));
            return ajc$this.domainMapper.domainToDomainDTO(domainEntity);
        }
        catch (Exception e) {
            LOG.error("Error to update domain {} with title {}", new Object[]{domainDTO.getId(), domainDTO.getTitle(), e});
            throw e;
        }
    }

    static /* synthetic */ void deleteDomain_aroundBody6(DomainService ajc$this, Long id, JoinPoint joinPoint) {
        try {
            DomainEntity domainEntity = (DomainEntity)ajc$this.domainStorage.find(id);
            if (domainEntity == null) {
                LOG.warn("Domain {} not Found", new Object[]{id});
                throw new EntityNotFoundException();
            }
            ajc$this.domainStorage.delete(domainEntity);
        }
        catch (Exception e) {
            LOG.error("Error to delete domain {}", new Object[]{id, e});
            throw e;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DomainService.java", DomainService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findDomainByTitle", "org.exoplatform.addons.gamification.service.configuration.DomainService", "java.lang.String", "domainTitle", "", "org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO"), 66);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addDomain", "org.exoplatform.addons.gamification.service.configuration.DomainService", "org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO", "domainDTO", "javax.persistence.PersistenceException", "org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO"), 89);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateDomain", "org.exoplatform.addons.gamification.service.configuration.DomainService", "org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO", "domainDTO", "javax.persistence.PersistenceException", "org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO"), 108);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteDomain", "org.exoplatform.addons.gamification.service.configuration.DomainService", "java.lang.Long", "id", "javax.persistence.EntityNotFoundException", "void"), 130);
    }
}

