/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.user;

import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;

@Asynchronous
public class GamificationUserLoginListener
extends Listener<ConversationRegistry, ConversationState> {
    private static final Log LOG = ExoLogger.getLogger(GamificationUserLoginListener.class);
    protected RuleService ruleService;
    protected IdentityManager identityManager;
    protected GamificationService gamificationService;

    public GamificationUserLoginListener(RuleService ruleService, IdentityManager identityManager, GamificationService gamificationService) {
        this.ruleService = ruleService;
        this.identityManager = identityManager;
        this.gamificationService = gamificationService;
    }

    public void onEvent(Event<ConversationRegistry, ConversationState> event) {
        String username = ((ConversationState)event.getData()).getIdentity().getUserId();
        String sender = this.identityManager.getOrCreateIdentity("organization", username, false).getId();
        this.gamificationService.createHistory("userLogin", sender, sender, null);
        LOG.debug("User Login Gamification for {}", new Object[]{username});
    }
}

