/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.task;

import java.util.Iterator;
import java.util.Set;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.service.TaskPayload;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.util.TaskUtil;

public class GamificationTaskUpdateListener
extends Listener<TaskService, TaskPayload> {
    private static final Log LOG = ExoLogger.getLogger(GamificationTaskUpdateListener.class);
    protected RuleService ruleService;
    protected IdentityManager identityManager;
    protected GamificationService gamificationService;

    public GamificationTaskUpdateListener(RuleService ruleService, IdentityManager identityManager, GamificationService gamificationService) {
        this.ruleService = ruleService;
        this.identityManager = identityManager;
        this.gamificationService = gamificationService;
    }

    public void onEvent(Event<TaskService, TaskPayload> event) throws Exception {
        TaskPayload data = (TaskPayload)event.getData();
        Task oldTask = data.before();
        Task newTask = data.after();
        if (oldTask == null && newTask != null) {
            this.createTask(newTask);
        }
        if (oldTask != null && newTask != null) {
            this.updateTask(oldTask, newTask);
        }
    }

    protected void createTask(Task task) {
        String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
        String actorId = this.identityManager.getOrCreateIdentity("organization", actorUsername, false).getId();
        this.gamificationService.createHistory("createNewTask", actorId, actorId, TaskUtil.buildTaskURL((Task)task));
    }

    protected void updateTask(Task before, Task after) {
        Object ruleDto = null;
        String actorId = "";
        Object aHistory = null;
        if (this.isDiff(before.isCompleted(), after.isCompleted())) {
            Set cowrokers;
            if (after.getAssignee() != null && after.getAssignee().length() != 0) {
                actorId = this.identityManager.getOrCreateIdentity("organization", after.getAssignee(), false).getId();
                this.gamificationService.createHistory("completeTaskAssigned", actorId, actorId, TaskUtil.buildTaskURL((Task)after));
            }
            if ((cowrokers = after.getCoworker()) == null) {
                return;
            }
            Iterator coworker = cowrokers.iterator();
            while (coworker.hasNext()) {
                actorId = this.identityManager.getOrCreateIdentity("organization", (String)coworker.next(), false).getId();
                this.gamificationService.createHistory("completeTaskCoworker", actorId, actorId, TaskUtil.buildTaskURL((Task)after));
            }
        } else {
            String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
            actorId = this.identityManager.getOrCreateIdentity("organization", actorUsername, false).getId();
            this.gamificationService.createHistory("updateTask", actorId, actorId, TaskUtil.buildTaskURL((Task)after));
        }
    }

    protected boolean isDiff(Object before, Object after) {
        if (before == after) {
            return false;
        }
        if (before != null) {
            return !before.equals(after);
        }
        return !after.equals(before);
    }
}

