/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.social.space;

import java.util.HashMap;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceService;

public class GamificationSpaceListener
extends SpaceListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(GamificationSpaceListener.class);
    protected RuleService ruleService = (RuleService)CommonsUtils.getService(RuleService.class);
    protected IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
    protected SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
    protected ListenerService listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);

    public void spaceCreated(SpaceLifeCycleEvent event) {
        String username = (String)event.getSource();
        Space space = event.getSpace();
        this.createGamificationHistoryEntry(username, space, "addSpace");
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
    }

    public void joined(SpaceLifeCycleEvent event) {
        String username = (String)event.getSource();
        Space space = event.getSpace();
        this.createGamificationHistoryEntry(username, space, "joinSpace");
    }

    public void left(SpaceLifeCycleEvent event) {
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
        String username = (String)event.getSource();
        Space space = event.getSpace();
        this.createGamificationHistoryEntry(username, space, "grantUserAsLead");
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
    }

    public void addInvitedUser(SpaceLifeCycleEvent event) {
    }

    public void addPendingUser(SpaceLifeCycleEvent event) {
    }

    public void spaceRegistrationEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceBannerEdited(SpaceLifeCycleEvent event) {
    }

    private void createGamificationHistoryEntry(String username, Space space, String ruleTitle) {
        HashMap<String, String> gam;
        String senderId = this.identityManager.getOrCreateIdentity("organization", username).getId();
        String receiverId = this.identityManager.getOrCreateIdentity("space", space.getPrettyName()).getId();
        String spaceURL = "/portal/g/:spaces:" + space.getGroupId().replace("/spaces/", "");
        try {
            gam = new HashMap<String, String>();
            gam.put("ruleTitle", ruleTitle);
            gam.put("object", spaceURL);
            gam.put("senderId", senderId);
            gam.put("receiverId", receiverId);
            this.listenerService.broadcast("exo.gamification.generic.action", gam, null);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot broadcast gamification event");
        }
        try {
            gam = new HashMap();
            gam.put("ruleTitle", ruleTitle);
            gam.put("object", spaceURL);
            gam.put("senderId", receiverId);
            gam.put("receiverId", senderId);
            this.listenerService.broadcast("exo.gamification.generic.action", gam, null);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot broadcast gamification event");
        }
    }
}

