/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.configuration;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleFilter;
import org.exoplatform.addons.gamification.storage.RuleStorage;
import org.exoplatform.addons.gamification.utils.Utils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.ListenerService;

public class RuleServiceImpl
implements RuleService {
    private static final String USERNAME_IS_MANDATORY_MESSAGE = "Username is mandatory";
    private final RuleStorage ruleStorage;
    private final ListenerService listenerService;

    public RuleServiceImpl(RuleStorage ruleStorage, ListenerService listenerService) {
        this.ruleStorage = ruleStorage;
        this.listenerService = listenerService;
    }

    @Override
    public RuleDTO findEnableRuleByTitle(String ruleTitle) throws IllegalArgumentException {
        RuleDTO rule = this.findRuleByTitle(ruleTitle);
        return rule != null && rule.isEnabled() ? rule : null;
    }

    @Override
    public RuleDTO findRuleById(long id) throws IllegalArgumentException {
        if (id == 0L) {
            throw new IllegalArgumentException("Rule id is mandatory");
        }
        return this.ruleStorage.findRuleById(id);
    }

    @Override
    public List<RuleDTO> findEnabledRulesByEvent(String event) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)event)) {
            throw new IllegalArgumentException("Rule event is mandatory");
        }
        return this.ruleStorage.findEnabledRulesByEvent(event);
    }

    @Override
    public RuleDTO findRuleByTitle(String ruleTitle) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)ruleTitle)) {
            throw new IllegalArgumentException("rule title is mandatory");
        }
        return this.ruleStorage.findRuleByTitle(ruleTitle);
    }

    @Override
    public RuleDTO findRuleByEventAndDomain(String ruleTitle, long domainId) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)ruleTitle)) {
            throw new IllegalArgumentException("Rule title is mandatory");
        }
        if (domainId < 0L) {
            throw new IllegalArgumentException("Domain id must be positive");
        }
        return this.ruleStorage.findRuleByEventAndDomain(ruleTitle, domainId);
    }

    @Override
    public List<RuleDTO> findAllRules() {
        return this.ruleStorage.findAllRules();
    }

    @Override
    public List<RuleDTO> findAllRules(int offset, int limit) {
        List<Long> rulesIds = this.ruleStorage.findAllRulesIds(offset, limit);
        ArrayList<RuleDTO> rules = new ArrayList<RuleDTO>();
        for (Long ruleId : rulesIds) {
            RuleDTO rule = this.findRuleById(ruleId);
            if (rule.isDeleted()) continue;
            rules.add(rule);
        }
        return rules;
    }

    @Override
    public List<RuleDTO> getRulesByFilter(RuleFilter ruleFilter, int offset, int limit) {
        List<Long> rulesIds = this.ruleStorage.findRulesIdsByFilter(ruleFilter, offset, limit);
        ArrayList<RuleDTO> rules = new ArrayList<RuleDTO>();
        this.ruleStorage.findRulesIdsByFilter(ruleFilter, offset, limit);
        for (Long ruleId : rulesIds) {
            RuleDTO rule = this.findRuleById(ruleId);
            if (rule.isDeleted()) continue;
            rules.add(rule);
        }
        return rules;
    }

    @Override
    public int countAllRules(RuleFilter ruleFilter) {
        return this.ruleStorage.countRulesByFilter(ruleFilter);
    }

    @Override
    public List<RuleDTO> getActiveRules() {
        return this.ruleStorage.getActiveRules();
    }

    @Override
    public List<RuleDTO> getAllRulesByDomain(String domain) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)domain)) {
            throw new IllegalArgumentException("rule domain is mandatory");
        }
        return this.ruleStorage.getAllRulesByDomain(domain);
    }

    @Override
    public List<RuleDTO> getAllRulesWithNullDomain() {
        return this.ruleStorage.getAllRulesWithNullDomain();
    }

    @Override
    public List<String> getAllEvents() {
        return this.ruleStorage.getAllEvents();
    }

    @Override
    public List<String> getDomainListFromRules() {
        return this.ruleStorage.getDomainListFromRules();
    }

    @Override
    public long getRulesTotalScoreByDomain(long domainId) {
        return this.ruleStorage.getRulesTotalScoreByDomain(domainId);
    }

    @Override
    public RuleDTO deleteRuleById(Long ruleId, String username) throws IllegalAccessException, ObjectNotFoundException {
        if (username == null) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        if (ruleId == null || ruleId <= 0L) {
            throw new IllegalArgumentException("ruleId must be positive");
        }
        RuleDTO ruleDTO = this.ruleStorage.findRuleById(ruleId);
        if (ruleDTO == null) {
            throw new ObjectNotFoundException("Rule with id " + ruleId + " is not found");
        }
        if (!Utils.isRuleManager(ruleDTO, username)) {
            throw new IllegalAccessException("The user is not authorized to delete a rule");
        }
        ruleDTO = this.ruleStorage.deleteRuleById(ruleId, username);
        Utils.broadcastEvent(this.listenerService, "rule.deleted", this, ruleDTO);
        return ruleDTO;
    }

    @Override
    public RuleDTO createRule(RuleDTO ruleDTO, String username) throws IllegalAccessException, ObjectAlreadyExistsException {
        if (ruleDTO == null) {
            throw new IllegalArgumentException("rule object is mandatory");
        }
        if (username == null) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        if (ruleDTO.getId() != null) {
            throw new IllegalArgumentException("domain id must be equal to 0");
        }
        if (!Utils.isRuleManager(ruleDTO, username)) {
            throw new IllegalAccessException("The user is not authorized to create a rule");
        }
        ruleDTO.setCreatedBy(username);
        ruleDTO.setLastModifiedBy(username);
        DomainDTO domainDTO = Utils.getDomainByTitle(ruleDTO.getArea());
        long domainId = domainDTO.getId();
        RuleDTO oldRule = this.ruleStorage.findRuleByEventAndDomain(ruleDTO.getEvent(), domainId);
        if (oldRule != null && !oldRule.isDeleted()) {
            throw new ObjectAlreadyExistsException((Object)"Rule with same event and domain already exist");
        }
        ruleDTO.setDomainDTO(domainDTO);
        return this.createRule(ruleDTO);
    }

    @Override
    public RuleDTO createRule(RuleDTO ruleDTO) {
        ruleDTO = this.ruleStorage.saveRule(ruleDTO);
        Utils.broadcastEvent(this.listenerService, "rule.created", this, ruleDTO.getId());
        return ruleDTO;
    }

    @Override
    public RuleDTO updateRule(RuleDTO ruleDTO, String username) throws ObjectNotFoundException, IllegalAccessException {
        if (username == null) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        RuleDTO oldRule = this.ruleStorage.findRuleById(ruleDTO.getId());
        if (oldRule == null) {
            throw new ObjectNotFoundException("Rule does not exist");
        }
        if (!Utils.isRuleManager(oldRule, username)) {
            throw new IllegalAccessException("The user is not authorized to update a rule");
        }
        ruleDTO.setCreatedBy(username);
        ruleDTO.setLastModifiedBy(username);
        return this.updateRule(ruleDTO);
    }

    @Override
    public RuleDTO updateRule(RuleDTO ruleDTO) throws ObjectNotFoundException {
        if (ruleDTO.getId() == null || ruleDTO.getId() == 0L || this.ruleStorage.findRuleById(ruleDTO.getId()) == null) {
            throw new ObjectNotFoundException("Rule id is mandatory");
        }
        DomainDTO domainDTO = ruleDTO.getDomainDTO();
        if (domainDTO != null) {
            long domainId = ruleDTO.getDomainDTO().getId();
            RuleDTO existRule = this.ruleStorage.findRuleByEventAndDomain(ruleDTO.getEvent(), domainId);
            if (existRule != null && !existRule.getId().equals(ruleDTO.getId()) && !existRule.isDeleted()) {
                throw new IllegalStateException("Rule with same event and domain already exist");
            }
        }
        ruleDTO.setLastModifiedDate(Utils.toRFC3339Date(new Date()));
        ruleDTO = this.ruleStorage.saveRule(ruleDTO);
        Utils.broadcastEvent(this.listenerService, "rule.updated", this, ruleDTO.getId());
        return ruleDTO;
    }
}

