/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage.dao;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addons.gamification.entities.domain.configuration.RuleEntity;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleFilter;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.DateFilterType;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityFilterType;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityStatusType;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityType;
import org.exoplatform.commons.api.persistence.GenericDAO;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RuleDAO
extends GenericDAOJPAImpl<RuleEntity, Long>
implements GenericDAO<RuleEntity, Long> {
    private static final String QUERY_FILTER_FIND_PREFIX = "Rule.findAllRules";
    private static final String QUERY_FILTER_COUNT_PREFIX = "Rule.countAllRules";
    private static final String DOMAIN_ID = "domainId";
    private static final Log LOG = ExoLogger.getLogger(RuleDAO.class);
    private Map<String, Boolean> filterNamedQueries = new HashMap<String, Boolean>();

    public RuleEntity findEnableRuleByTitle(String ruleTitle) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.findEnabledRuleByTitle", RuleEntity.class).setParameter("ruleTitle", (Object)ruleTitle);
        query.setParameter("type", (Object)EntityType.AUTOMATIC);
        try {
            List ruleEntities = query.getResultList();
            return !ruleEntities.isEmpty() ? (RuleEntity)ruleEntities.get(0) : null;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<Long> findHighestBudgetDomainIds(int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getHighestBudgetDomainIds", Long.class);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    public List<Long> findHighestBudgetDomainIdsBySpacesIds(List<Long> spacesIds, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getHighestBudgetDomainIdsBySpacesIds", Long.class);
        query.setParameter("spacesIds", spacesIds);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    public List<RuleEntity> findEnabledRulesByEvent(String event) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.findEnabledRulesByEvent", RuleEntity.class).setParameter("event", (Object)event);
        query.setParameter("type", (Object)EntityType.AUTOMATIC);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public RuleEntity findRuleByTitle(String ruleTitle) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.findRuleByTitle", RuleEntity.class);
        query.setParameter("ruleTitle", (Object)ruleTitle);
        query.setParameter("type", (Object)EntityType.AUTOMATIC);
        try {
            List ruleEntities = query.getResultList();
            return !ruleEntities.isEmpty() ? (RuleEntity)ruleEntities.get(0) : null;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public RuleEntity findRuleByEventAndDomain(String event, long domainId) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.findRuleByEventAndDomain", RuleEntity.class).setParameter("event", (Object)event).setParameter(DOMAIN_ID, (Object)domainId);
        query.setParameter("type", (Object)EntityType.AUTOMATIC);
        try {
            List ruleEntities = query.getResultList();
            return !ruleEntities.isEmpty() ? (RuleEntity)ruleEntities.get(0) : null;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<RuleEntity> getAllRules() throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getAllRules", RuleEntity.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<RuleEntity> getActiveRules() {
        try {
            TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getEnabledRules", RuleEntity.class).setParameter("isEnabled", (Object)true);
            query.setParameter("type", (Object)EntityType.AUTOMATIC);
            return query.getResultList();
        }
        catch (PersistenceException e) {
            LOG.error((Object)"Error : Unable to fetch active rules", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<RuleEntity> getAllRulesByDomain(String domain) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getAllRulesByDomain", RuleEntity.class).setParameter("domain", (Object)domain);
        query.setParameter("type", (Object)EntityType.AUTOMATIC);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<RuleEntity> getAllRulesWithNullDomain() throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getAllRulesWithNullDomain", RuleEntity.class);
        query.setParameter("type", (Object)EntityType.AUTOMATIC);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<String> getDomainList() throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getDomainList", String.class);
        query.setParameter("type", (Object)EntityType.AUTOMATIC);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public long getRulesTotalScoreByDomain(long domainId) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getRulesTotalScoreByDomain", Long.class).setParameter(DOMAIN_ID, (Object)domainId).setParameter("date", (Object)Calendar.getInstance().getTime());
        Long score = (Long)query.getSingleResult();
        return score == null ? 0L : (long)score.intValue();
    }

    public List<String> getAllEvents() throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getEventList", String.class);
        query.setParameter("type", (Object)EntityType.AUTOMATIC);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<String> getRuleEventsByType(EntityType ruleType) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getEventList", String.class);
        query.setParameter("type", (Object)ruleType);
        return query.getResultList();
    }

    public List<Long> getRuleIdsByType(EntityType ruleType) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getRuleIdsByType", Long.class);
        query.setParameter("type", (Object)ruleType);
        return query.getResultList();
    }

    public List<Long> findRulesIdsByFilter(RuleFilter filter, int offset, int limit) {
        TypedQuery<Long> query = this.buildQueryFromFilter(filter, Long.class, false);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    public int countRulesByFilter(RuleFilter filter) {
        TypedQuery<Long> query = this.buildQueryFromFilter(filter, Long.class, true);
        return ((Long)query.getSingleResult()).intValue();
    }

    private <T> TypedQuery<T> buildQueryFromFilter(RuleFilter filter, Class<T> clazz, boolean count) {
        TypedQuery query;
        ArrayList<String> suffixes = new ArrayList<String>();
        ArrayList<String> predicates = new ArrayList<String>();
        this.buildPredicates(filter, suffixes, predicates);
        String queryName = this.getQueryFilterName(suffixes, count);
        if (this.filterNamedQueries.containsKey(queryName)) {
            query = this.getEntityManager().createNamedQuery(queryName, clazz);
        } else {
            String queryContent = this.getQueryFilterContent(predicates, count);
            query = this.getEntityManager().createQuery(queryContent, clazz);
            this.getEntityManager().getEntityManagerFactory().addNamedQuery(queryName, (Query)query);
            this.filterNamedQueries.put(queryName, true);
        }
        this.addQueryFilterParameters(filter, query);
        return query;
    }

    private <T> void addQueryFilterParameters(RuleFilter filter, TypedQuery<T> query) {
        EntityStatusType entityStatusType;
        EntityFilterType entityFilterType;
        DateFilterType dateFilterType;
        if (filter.getDomainId() > 0L) {
            query.setParameter(DOMAIN_ID, (Object)filter.getDomainId());
        }
        if (CollectionUtils.isNotEmpty(filter.getSpaceIds())) {
            query.setParameter("ids", filter.getSpaceIds());
        }
        if ((dateFilterType = filter.getDateFilterType()) != null && dateFilterType != DateFilterType.ALL) {
            query.setParameter("date", (Object)Calendar.getInstance().getTime());
        }
        if ((entityFilterType = filter.getEntityFilterType()) != null && entityFilterType != EntityFilterType.ALL) {
            query.setParameter("filterType", (Object)EntityType.valueOf(filter.getEntityFilterType().name()));
        }
        if (filter.getExcludedChallengesIds() != null && CollectionUtils.isNotEmpty(filter.getExcludedChallengesIds())) {
            query.setParameter("excludedIds", filter.getExcludedChallengesIds());
        }
        if ((entityStatusType = filter.getEntityStatusType()) == null || entityStatusType == EntityStatusType.ALL) {
            if (filter.getEntityFilterType() != EntityFilterType.MANUAL) {
                query.setParameter("date", (Object)Calendar.getInstance().getTime());
            }
        } else {
            switch (filter.getEntityStatusType()) {
                case ENABLED: {
                    query.setParameter("enabled", (Object)true);
                    query.setParameter("date", (Object)Calendar.getInstance().getTime());
                    break;
                }
                case DISABLED: {
                    query.setParameter("enabled", (Object)false);
                    query.setParameter("date", (Object)Calendar.getInstance().getTime());
                    break;
                }
            }
        }
    }

    private void buildPredicates(RuleFilter filter, List<String> suffixes, List<String> predicates) {
        EntityStatusType entityStatusType;
        EntityFilterType entityFilterType;
        if (filter.getDomainId() > 0L) {
            suffixes.add("Domain");
            predicates.add("r.domainEntity.id = :domainId");
        }
        if (CollectionUtils.isNotEmpty(filter.getSpaceIds())) {
            suffixes.add("Audience");
            predicates.add("(r.audience in (:ids) OR r.audience IS NULL)");
        }
        if (filter.getExcludedChallengesIds() != null && CollectionUtils.isNotEmpty(filter.getExcludedChallengesIds())) {
            suffixes.add("ExcludeIds");
            predicates.add("r.id NOT IN :excludedIds");
        }
        if (filter.getDateFilterType() != null) {
            DateFilterType dateFilterType = filter.getDateFilterType();
            suffixes.add("Enabled");
            predicates.add("r.isEnabled = true");
            switch (dateFilterType) {
                case STARTED: {
                    suffixes.add("StartDateAndEndDate");
                    predicates.add("r.startDate <= :date AND r.endDate >= :date");
                    break;
                }
                case NOT_STARTED: {
                    suffixes.add("StartDate");
                    predicates.add("r.startDate > :date");
                    break;
                }
                case ENDED: {
                    suffixes.add("EndDate");
                    predicates.add("r.endDate < :date");
                    break;
                }
            }
        }
        if ((entityFilterType = filter.getEntityFilterType()) != null && entityFilterType != EntityFilterType.ALL) {
            suffixes.add("FilterType");
            predicates.add("r.type = :filterType");
        }
        if (!filter.isIncludeDeleted()) {
            suffixes.add("ExcludeDeleted");
            predicates.add("r.isDeleted = false");
        }
        if ((entityStatusType = filter.getEntityStatusType()) == null || entityStatusType == EntityStatusType.ALL) {
            if (filter.getEntityFilterType() != EntityFilterType.MANUAL) {
                suffixes.add("FilterByALL");
                predicates.add("(r.type = 0 OR (r.startDate <= :date AND r.endDate >= :date AND r.type = 1))");
            }
        } else {
            switch (filter.getEntityStatusType()) {
                case ENABLED: {
                    suffixes.add("FilterByEnabled");
                    predicates.add("r.isEnabled = :enabled AND (r.type = 0 OR (r.startDate <= :date AND r.endDate >= :date AND r.type = 1))");
                    break;
                }
                case DISABLED: {
                    suffixes.add("FilterByDisabled");
                    predicates.add("r.isEnabled = :enabled AND (r.type = 0 OR (r.startDate <= :date AND r.endDate >= :date AND r.type = 1))");
                    break;
                }
            }
        }
    }

    private String getQueryFilterName(List<String> suffixes, boolean count) {
        Object queryName = suffixes.isEmpty() ? (count ? QUERY_FILTER_COUNT_PREFIX : QUERY_FILTER_FIND_PREFIX) : (count ? QUERY_FILTER_COUNT_PREFIX : QUERY_FILTER_FIND_PREFIX) + "By" + StringUtils.join(suffixes, (String)"By");
        return queryName;
    }

    private String getQueryFilterContent(List<String> predicates, boolean count) {
        String querySelect = count ? "SELECT COUNT(r) FROM Rule r " : "SELECT r.id FROM Rule r ";
        String orderBy = " ORDER BY r.score DESC";
        Object queryContent = predicates.isEmpty() ? querySelect : querySelect + " WHERE " + StringUtils.join(predicates, (String)" AND ");
        if (!count) {
            queryContent = (String)queryContent + orderBy;
        }
        return queryContent;
    }
}

