/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage.cached;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.gamification.dao.ProgramDAO;
import io.meeds.gamification.dao.RuleDAO;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.storage.ProgramStorage;
import io.meeds.gamification.storage.cached.ProgramCachedStorage$AjcClosure1;
import io.meeds.gamification.storage.cached.ProgramCachedStorage$RewardingAdministratorUserListener$AjcClosure1;
import jakarta.servlet.ServletContext;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.cache.future.FutureCache;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.upload.UploadService;

public class ProgramCachedStorage
extends ProgramStorage {
    private static final String PROGRAM_CACHE_NAME = "gamification.domain";
    private FutureExoCache<Long, ProgramDTO, Object> programFutureCache;
    private FutureCache<Object, List<String>, Object> administratorsRetrivalTask;
    private List<String> administrators;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public ProgramCachedStorage(FileService fileService, UploadService uploadService, ProgramDAO programDAO, RuleDAO ruleDAO, CacheService cacheService, ListenerService listenerService, OrganizationService organizationService, PortalContainer container) {
        super(fileService, uploadService, programDAO, ruleDAO, organizationService);
        ExoCache programCache = cacheService.getCacheInstance(PROGRAM_CACHE_NAME);
        Loader<Long, ProgramDTO, Object> programLoader = new Loader<Long, ProgramDTO, Object>(){

            public ProgramDTO retrieve(Object context, Long id) throws Exception {
                return ProgramCachedStorage.super.getProgramById(id);
            }
        };
        this.programFutureCache = new FutureExoCache((Loader)programLoader, programCache);
        this.administratorsRetrivalTask = new FutureCache<Object, List<String>, Object>((c, k) -> this.getAdministratorsConcurrently()){

            protected List<String> get(Object key) {
                return ProgramCachedStorage.this.administrators;
            }

            protected void put(Object key, List<String> value) {
                ProgramCachedStorage.this.administrators = value;
            }

            protected void putOnly(Object key, List<String> value) {
                ProgramCachedStorage.this.administrators = value;
            }
        };
        listenerService.addListener("rule.created", (Listener)new RuleUpdatedListener());
        listenerService.addListener("rule.deleted", (Listener)new RuleUpdatedListener());
        listenerService.addListener("rule.updated", (Listener)new RuleUpdatedListener());
        organizationService.getMembershipHandler().addMembershipEventListener((MembershipEventListener)new RewardingAdministratorMembershipListener());
        organizationService.getUserHandler().addUserEventListener((UserEventListener)new RewardingAdministratorUserListener());
        PortalContainer.addInitTask((ServletContext)container.getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostCreateTask(){

            public void execute(ServletContext context, PortalContainer portalContainer) {
                ProgramCachedStorage.this.getAdministrators();
            }
        });
    }

    @Override
    public ProgramDTO saveProgram(ProgramDTO program) {
        try {
            ProgramDTO programDTO = program = super.saveProgram(program);
            return programDTO;
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    public void updateProgramDate(long programId) {
        try {
            super.updateProgramDate(programId);
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    public ProgramDTO getProgramById(Long id) {
        ProgramDTO program = (ProgramDTO)this.programFutureCache.get(null, (Object)id);
        return program == null ? null : program.clone();
    }

    @Override
    public void deleteImage(long fileId) {
        try {
            super.deleteImage(fileId);
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    public List<String> getAdministrators() {
        if (this.administrators == null) {
            return (List)this.administratorsRetrivalTask.get(null, (Object)"administrators");
        }
        return this.administrators;
    }

    @Override
    public void clearCache() {
        this.programFutureCache.clear();
    }

    @ContainerTransactional
    public List<String> getAdministratorsConcurrently() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        ProgramCachedStorage$AjcClosure1 programCachedStorage$AjcClosure1 = new ProgramCachedStorage$AjcClosure1(objectArray);
        return (List)ContainerTransactionalAspect.aspectOf().around(programCachedStorage$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    static {
        ProgramCachedStorage.ajc$preClinit();
    }

    static /* synthetic */ List getAdministratorsConcurrently_aroundBody0(ProgramCachedStorage ajc$this, JoinPoint joinPoint) {
        return super.getAdministrators();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ProgramCachedStorage.java", ProgramCachedStorage.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAdministratorsConcurrently", "io.meeds.gamification.storage.cached.ProgramCachedStorage", "", "", "", "java.util.List"), 167);
    }

    public class RuleUpdatedListener
    extends Listener<Object, String> {
        public void onEvent(Event<Object, String> event) throws Exception {
            ProgramCachedStorage.this.clearCache();
        }
    }

    public class RewardingAdministratorMembershipListener
    extends MembershipEventListener {
        public void postSave(Membership m, boolean isNew) throws Exception {
            CompletableFuture.runAsync(() -> this.clearCachedAdministrators(m));
        }

        public void postDelete(Membership m) throws Exception {
            CompletableFuture.runAsync(() -> this.clearCachedAdministrators(m));
        }

        private void clearCachedAdministrators(Membership m) {
            if (m != null && "/platform/rewarding".equals(m.getGroupId())) {
                ProgramCachedStorage.this.administrators = null;
            }
        }
    }

    public class RewardingAdministratorUserListener
    extends UserEventListener {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        public void postSetEnabled(User user) throws Exception {
            CompletableFuture.runAsync(() -> this.clearCachedAdministrator(user));
        }

        public void postDelete(User user) throws Exception {
            CompletableFuture.runAsync(() -> this.clearCachedAdministrator(user));
        }

        @ContainerTransactional
        public void clearCachedAdministrator(User user) {
            User user2 = user;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)user2);
            Object[] objectArray = new Object[]{this, user2, joinPoint};
            ProgramCachedStorage$RewardingAdministratorUserListener$AjcClosure1 programCachedStorage$RewardingAdministratorUserListener$AjcClosure1 = new ProgramCachedStorage$RewardingAdministratorUserListener$AjcClosure1(objectArray);
            ContainerTransactionalAspect.aspectOf().around(programCachedStorage$RewardingAdministratorUserListener$AjcClosure1.linkClosureAndJoinPoint(69648));
        }

        static {
            RewardingAdministratorUserListener.ajc$preClinit();
        }

        static /* synthetic */ void clearCachedAdministrator_aroundBody0(RewardingAdministratorUserListener ajc$this, User user, JoinPoint joinPoint) {
            if (ajc$this.ProgramCachedStorage.this.administrators != null && (ajc$this.ProgramCachedStorage.this.administrators.stream().anyMatch(u -> StringUtils.equals((CharSequence)u, (CharSequence)user.getUserName())) || CollectionUtils.isNotEmpty((Collection)ajc$this.ProgramCachedStorage.this.organizationService.getMembershipHandler().findMembershipsByUserAndGroup(user.getUserName(), "/platform/rewarding")))) {
                ajc$this.ProgramCachedStorage.this.administrators = null;
            }
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("ProgramCachedStorage.java", RewardingAdministratorUserListener.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clearCachedAdministrator", "io.meeds.gamification.storage.cached.ProgramCachedStorage$RewardingAdministratorUserListener", "org.exoplatform.services.organization.User", "user", "", "void"), 210);
        }
    }
}

