/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextItemEntity;
import org.exoplatform.addons.gamification.service.configuration.BadgeService;
import org.exoplatform.addons.gamification.service.dto.configuration.BadgeDTO;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/gamification/reputation")
@Produces(value={"application/json"})
@RolesAllowed(value={"users"})
public class UserReputationEndpoint
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(UserReputationEndpoint.class);
    private final CacheControl cacheControl = new CacheControl();
    protected GamificationService gamificationService = null;
    protected IdentityManager identityManager = null;
    protected BadgeService badgeService = null;

    public UserReputationEndpoint() {
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
        this.gamificationService = (GamificationService)CommonsUtils.getService(GamificationService.class);
        this.identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        this.badgeService = (BadgeService)CommonsUtils.getService(BadgeService.class);
    }

    @GET
    @Path(value="point/status")
    public Response getReputationStatus(@Context UriInfo uriInfo, @Context HttpServletRequest request, @QueryParam(value="url") String url) {
        ConversationState conversationState = ConversationState.getCurrent();
        String profileOwner = UserReputationEndpoint.substringAfterLast(url, "/");
        if (conversationState != null) {
            try {
                String actorId = this.identityManager.getOrCreateIdentity("organization", profileOwner, false).getId();
                JSONObject reputation = new JSONObject();
                reputation.put("points", this.gamificationService.getUserGlobalScore(actorId));
                return Response.ok().cacheControl(this.cacheControl).entity((Object)reputation.toString()).build();
            }
            catch (Exception e) {
                LOG.error("Error to calculate repuation score for user {} ", new Object[]{profileOwner, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error to compute the user reputaiotn points").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @GET
    @Path(value="badge/all")
    public Response getUserBadges(@Context UriInfo uriInfo, @Context HttpServletRequest request, @QueryParam(value="url") String url) {
        ConversationState conversationState = ConversationState.getCurrent();
        String streamOwner = UserReputationEndpoint.substringAfterLast(url, "/");
        if (conversationState != null) {
            try {
                JSONArray allBadges = new JSONArray();
                String actorId = this.identityManager.getOrCreateIdentity("organization", streamOwner, false).getId();
                Set<GamificationContextItemEntity> gamificationContextItemEntitySet = this.gamificationService.getUserGamification(actorId);
                allBadges = this.buildProfileBadge(gamificationContextItemEntitySet);
                return Response.ok().cacheControl(this.cacheControl).entity((Object)allBadges.toString()).build();
            }
            catch (Exception e) {
                LOG.error("Error loading badges belong to user : {} ", new Object[]{streamOwner, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error loading user's badges").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @GET
    @Path(value="badge/{badge}/avatar")
    public Response getSpaceAvatarById(@Context UriInfo uriInfo, @Context Request request, @PathParam(value="badge") String badgeTitle) throws IOException {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            try {
                Response.ResponseBuilder builder;
                BadgeDTO badgeDTO = this.badgeService.findBadgeByTitle(badgeTitle);
                Long lastUpdated = null;
                if (badgeDTO != null) {
                    lastUpdated = new SimpleDateFormat("yyyy-MM-dd").parse(badgeDTO.getLastModifiedDate()).getTime();
                }
                EntityTag eTag = null;
                if (lastUpdated != null) {
                    eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
                }
                Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
                if (builder == null) {
                    InputStream stream = this.getBadgeAvatarInputStream(badgeDTO);
                    if (stream == null) {
                        throw new WebApplicationException(Response.Status.NOT_FOUND);
                    }
                    builder = Response.ok((Object)stream, (String)"image/png");
                    builder.tag(eTag);
                }
                CacheControl cc = new CacheControl();
                cc.setMaxAge(86400);
                builder.cacheControl(cc);
                return builder.cacheControl(cc).build();
            }
            catch (Exception e) {
                LOG.error((Object)"Error getting badge's avatar", (Throwable)e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error getting badge's avatar").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    private InputStream getBadgeAvatarInputStream(BadgeDTO badgeDTO) throws IOException {
        FileItem file = null;
        if (badgeDTO == null) {
            return null;
        }
        Long avatarId = badgeDTO.getIconFileId();
        if (avatarId == null) {
            return null;
        }
        try {
            file = ((FileService)CommonsUtils.getService(FileService.class)).getFile(avatarId.longValue());
        }
        catch (FileStorageException e) {
            return null;
        }
        if (file == null) {
            return null;
        }
        return file.getAsStream();
    }

    private JSONArray buildProfileBadge(Set<GamificationContextItemEntity> gamificationContextItemEntitySet) {
        JSONArray allBadges = new JSONArray();
        if (gamificationContextItemEntitySet != null && !gamificationContextItemEntitySet.isEmpty()) {
            JSONObject reputation = null;
            int userScore = gamificationContextItemEntitySet.stream().filter(i -> i.getZone().equalsIgnoreCase("social")).map(GamificationContextItemEntity::getScore).mapToInt(Integer::intValue).sum();
            List<BadgeDTO> badgeDTOS = this.buildWonBadges("social", userScore);
            int startScore = 0;
            int k = 0;
            for (int i2 = 0; i2 < badgeDTOS.size(); ++i2) {
                BadgeDTO badgeDTO = badgeDTOS.get(i2);
                reputation = new JSONObject();
                try {
                    String iconUrl = "/rest/gamification/reputation/badge/" + badgeDTO.getTitle() + "/avatar";
                    reputation.put("url", (Object)iconUrl);
                    reputation.put("description", (Object)badgeDTO.getDescription());
                    reputation.put("id", i2);
                    reputation.put("title", (Object)badgeDTO.getTitle());
                    reputation.put("zone", (Object)badgeDTO.getDomain());
                    reputation.put("level", ++k);
                    reputation.put("startScore", startScore);
                    reputation.put("endScore", badgeDTO.getNeededScore());
                    startScore += badgeDTO.getNeededScore();
                    allBadges.put((Object)reputation);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return allBadges;
    }

    private List<BadgeDTO> buildWonBadges(String zone, int score) {
        List<BadgeDTO> allBadges = this.badgeService.getAllBadges();
        return allBadges.stream().filter(b -> b.getDomain().equalsIgnoreCase(zone)).filter(b -> b.getNeededScore() < score).collect(Collectors.toList());
    }

    private static String substringAfterLast(String str, String separator) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        if (StringUtils.isEmpty((CharSequence)separator)) {
            return "";
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return "";
        }
        return str.substring(pos + separator.length());
    }
}

