/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage.dao;

import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.TypedQuery;
import org.exoplatform.addons.gamification.entities.domain.configuration.RuleEntity;
import org.exoplatform.commons.api.persistence.GenericDAO;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class RuleDAO
extends GenericDAOJPAImpl<RuleEntity, Long>
implements GenericDAO<RuleEntity, Long> {
    public RuleEntity findEnableRuleByTitle(String ruleTitle) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.findEnabledRuleByTitle", RuleEntity.class).setParameter("ruleTitle", (Object)ruleTitle);
        try {
            return (RuleEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<RuleEntity> getAllRules() throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getAllRules", RuleEntity.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public int deleteRuleById(int ruleId) throws PersistenceException {
        return this.getEntityManager().createNamedQuery("Rule.deleteRuleById").setParameter("ruleId", (Object)ruleId).executeUpdate();
    }

    public int deleteRuleByTitle(String ruleTitle) throws PersistenceException {
        return this.getEntityManager().createNamedQuery("Rule.deleteRuleByTitle").setParameter("ruleTitle", (Object)ruleTitle).executeUpdate();
    }

    public void clear() {
        this.getEntityManager().clear();
    }
}

