/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.migration.datamodel;

import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import javax.servlet.ServletContext;
import org.exoplatform.addons.gamification.GamificationUtils;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextEntity;
import org.exoplatform.addons.gamification.storage.dao.GamificationDAO;
import org.exoplatform.addons.gamification.storage.dao.GamificationHistoryDAO;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DataModelMigration {
    private static final Log LOG = ExoLogger.getLogger(DataModelMigration.class);
    private static String MIGRATION_PROCESS_SOCIAL_DOMAIN = "Social";
    private static String MIGRATION_PROCESS_KNOWLEDGE_DOMAIN = "Knowledge";
    private static String MIGRATION_PROCESS_MIGRATION_SOCIAL_ENTRIES = "migrateSocialEntries";
    private static String MIGRATION_PROCESS_MIGRATION_KNOWLEDGE_ENTRIES = "migrateKnowledgeEntries";
    private static String MIGRATION_PROCESS_LABEL = "Gamification Migration Process";
    private GamificationDAO gamificationDAO;
    private GamificationHistoryDAO gamificationHistoryDAO;
    private SettingService settingService;

    public DataModelMigration(GamificationDAO gamificationDAO, SettingService settingService, GamificationHistoryDAO gamificationHistoryDAO) {
        this.gamificationDAO = gamificationDAO;
        this.settingService = settingService;
        this.gamificationHistoryDAO = gamificationHistoryDAO;
    }

    public void migrate() {
        PortalContainer.addInitTask((ServletContext)PortalContainer.getInstance().getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostInitTask(){

            public void execute(ServletContext context, PortalContainer portalContainer) {
                GamificationUtils.getExecutorService().submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                        if (!GamificationUtils.isGamificationDatamodelMigrated()) {
                            try {
                                ExoContainerContext.setCurrentContainer((ExoContainer)PortalContainer.getInstance());
                                LOG.info((Object)"=== Start migration of Gamification data model");
                                long startTime = System.currentTimeMillis();
                                DataModelMigration.this.migrateOldDatamodelentries();
                                long endTime = System.currentTimeMillis();
                                LOG.info((Object)("=== Migration of Gamiffication datab model is done in " + (endTime - startTime) + " ms"));
                            }
                            catch (Exception e) {
                                LOG.error((Object)("Error while migrating Gamification data model - Cause : " + e.getMessage()), (Throwable)e);
                            }
                        } else {
                            LOG.info((Object)"No Gamification entry data to migrate");
                        }
                        return null;
                    }
                });
            }
        });
    }

    private void migrateOldDatamodelentries() throws Exception {
        int current = 0;
        try {
            List gamification = this.gamificationDAO.findAll();
            int totalEntries = 0;
            LOG.info((Object)("    Number of gamification entries to process = " + totalEntries));
            if (gamification != null) {
                totalEntries = gamification.size();
            }
            double userPercent = 0.0;
            for (GamificationContextEntity entry : gamification) {
                LOG.info("Migrate gamification entry service=gamification operation=migration parameters=\"user_social_id:{}, global_score:{}, progress:{} %\"", new Object[]{entry.getUsername(), entry.getScore(), userPercent});
                if (!GamificationUtils.isGamificationDatamodelMigrated(entry.getUsername())) {
                    this.migrateEntry(entry);
                }
                userPercent = (double)(++current) / (double)totalEntries * 100.0;
            }
            GamificationUtils.setGamificationDatamodelMigrationDone();
        }
        catch (Exception e) {
            LOG.error((Object)("Error while migrating Gamification DataModel - Cause : " + e.getMessage()), (Throwable)e);
        }
    }

    private void migrateEntry(GamificationContextEntity entry) throws Exception {
        if (GamificationUtils.isBlackListed(entry.getUsername())) {
            return;
        }
        LocalDate gamificationRollOutDate = LocalDate.of(2018, Month.AUGUST, 24);
        GamificationActionsHistory actionsHistory = new GamificationActionsHistory();
        actionsHistory.setUserSocialId(entry.getUsername());
        long socialScore = this.calculateSocialScore(entry.getScore());
        actionsHistory.setGlobalScore(socialScore);
        actionsHistory.setActionScore(socialScore);
        actionsHistory.setDomain(MIGRATION_PROCESS_SOCIAL_DOMAIN);
        actionsHistory.setActionTitle(MIGRATION_PROCESS_MIGRATION_SOCIAL_ENTRIES);
        actionsHistory.setDate(Date.from(gamificationRollOutDate.atStartOfDay(ZoneId.systemDefault()).toInstant()));
        actionsHistory.setCreatedBy(MIGRATION_PROCESS_LABEL);
        actionsHistory.setLastModifiedBy(MIGRATION_PROCESS_LABEL);
        actionsHistory.setCreatedDate(new Date());
        actionsHistory.setLastModifiedDate(new Date());
        this.gamificationHistoryDAO.create(actionsHistory);
        actionsHistory = new GamificationActionsHistory();
        actionsHistory.setUserSocialId(entry.getUsername());
        actionsHistory.setGlobalScore(entry.getScore() - socialScore);
        actionsHistory.setActionScore(entry.getScore() - socialScore);
        actionsHistory.setDomain(MIGRATION_PROCESS_KNOWLEDGE_DOMAIN);
        actionsHistory.setActionTitle(MIGRATION_PROCESS_MIGRATION_KNOWLEDGE_ENTRIES);
        actionsHistory.setDate(Date.from(gamificationRollOutDate.atStartOfDay(ZoneId.systemDefault()).toInstant()));
        actionsHistory.setCreatedBy(MIGRATION_PROCESS_LABEL);
        actionsHistory.setLastModifiedBy(MIGRATION_PROCESS_LABEL);
        actionsHistory.setCreatedDate(new Date());
        actionsHistory.setLastModifiedDate(new Date());
        this.gamificationHistoryDAO.create(actionsHistory);
        this.settingService.set(Context.USER.id(entry.getUsername()), Scope.APPLICATION.id("GAMIFICATION_DATAMODEL_MIGRATION_USER"), "GAMIFICATION_DATAMODEL_MIGRATION_DONE", SettingValue.create((String)"true"));
    }

    private long calculateSocialScore(long total) {
        long socialScore = 0L;
        socialScore = total * 2L / 3L;
        return socialScore;
    }
}

