/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.addons.gamification.GamificationUtils;
import org.exoplatform.addons.gamification.service.configuration.BadgeService;
import org.exoplatform.addons.gamification.service.dto.configuration.BadgeDTO;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.addons.gamification.service.effective.ProfileReputation;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/gamification/reputation")
@Produces(value={"application/json"})
@RolesAllowed(value={"users"})
public class UserReputationEndpoint
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(UserReputationEndpoint.class);
    private final CacheControl cacheControl = new CacheControl();
    protected GamificationService gamificationService = null;
    protected IdentityManager identityManager = null;
    protected BadgeService badgeService = null;

    public UserReputationEndpoint() {
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
        this.gamificationService = (GamificationService)CommonsUtils.getService(GamificationService.class);
        this.identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        this.badgeService = (BadgeService)CommonsUtils.getService(BadgeService.class);
    }

    @GET
    @Path(value="status")
    public Response getReputationStatus(@Context UriInfo uriInfo, @Context HttpServletRequest request, @QueryParam(value="url") String url) {
        ConversationState conversationState = ConversationState.getCurrent();
        String profileOwner = GamificationUtils.extractProfileOwnerFromUrl(url, "/");
        long userReputationScore = 0L;
        if (conversationState != null) {
            try {
                String actorId = this.identityManager.getOrCreateIdentity("organization", profileOwner, false).getId();
                JSONObject reputation = new JSONObject();
                userReputationScore = this.gamificationService.findUserReputationBySocialId(actorId);
                reputation.put("score", userReputationScore);
                return Response.ok().cacheControl(this.cacheControl).entity((Object)reputation.toString()).build();
            }
            catch (Exception e) {
                LOG.error("Error to calculate repuation score for user {} ", new Object[]{profileOwner, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error to compute the user reputaiotn points").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @GET
    @Path(value="badges")
    public Response getUserBadges(@Context UriInfo uriInfo, @Context HttpServletRequest request, @QueryParam(value="url") String url) {
        ConversationState conversationState = ConversationState.getCurrent();
        String profilePageOwner = GamificationUtils.extractProfileOwnerFromUrl(url, "/");
        if (conversationState != null) {
            try {
                JSONArray allBadges = new JSONArray();
                String actorId = this.identityManager.getOrCreateIdentity("organization", profilePageOwner, false).getId();
                List<ProfileReputation> badgesByDomain = this.gamificationService.buildDomainScoreByUserId(actorId);
                allBadges = this.buildProfileBadges(badgesByDomain);
                return Response.ok().cacheControl(this.cacheControl).entity((Object)allBadges.toString()).build();
            }
            catch (Exception e) {
                LOG.error("Error loading badges belong to user : {} ", new Object[]{profilePageOwner, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error loading user's badges").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @GET
    @Path(value="badge/{badge}/avatar")
    public Response getSpaceAvatarById(@Context UriInfo uriInfo, @Context Request request, @PathParam(value="badge") String badgeTitle) throws IOException {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            InputStream stream = null;
            try {
                Response.ResponseBuilder builder;
                BadgeDTO badgeDTO = this.badgeService.findBadgeByTitle(badgeTitle);
                Long lastUpdated = null;
                if (badgeDTO != null) {
                    lastUpdated = new SimpleDateFormat("yyyy-MM-dd").parse(badgeDTO.getLastModifiedDate()).getTime();
                } else {
                    stream = UserReputationEndpoint.class.getClassLoader().getResourceAsStream("medias/images/default_badge.png");
                }
                EntityTag eTag = null;
                if (lastUpdated != null) {
                    eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
                }
                Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
                if (builder == null) {
                    if (stream == null && (stream = this.getBadgeAvatarInputStream(badgeDTO)) == null) {
                        throw new WebApplicationException(Response.Status.NOT_FOUND);
                    }
                    builder = Response.ok((Object)stream, (String)"image/png");
                    builder.tag(eTag);
                }
                CacheControl cc = new CacheControl();
                cc.setMaxAge(86400);
                builder.cacheControl(cc);
                return builder.cacheControl(cc).build();
            }
            catch (Exception e) {
                LOG.error((Object)"Error getting badge's avatar", (Throwable)e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error getting badge's avatar").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    private InputStream getBadgeAvatarInputStream(BadgeDTO badgeDTO) throws IOException {
        FileItem file = null;
        if (badgeDTO == null) {
            return null;
        }
        Long avatarId = badgeDTO.getIconFileId();
        if (avatarId == null) {
            return null;
        }
        try {
            file = ((FileService)CommonsUtils.getService(FileService.class)).getFile(avatarId.longValue());
        }
        catch (FileStorageException e) {
            return null;
        }
        if (file == null) {
            return null;
        }
        return file.getAsStream();
    }

    private JSONArray buildProfileBadges(List<ProfileReputation> reputationLis) {
        JSONArray allBadges = new JSONArray();
        if (reputationLis != null && !reputationLis.isEmpty()) {
            for (ProfileReputation rep : reputationLis) {
                this.buildLatestWonBadge(rep.getDomain(), rep.getScore(), allBadges);
            }
        }
        return allBadges;
    }

    private void buildLatestWonBadge(String domain, long score, JSONArray userBadges) {
        try {
            List<BadgeDTO> allBadges = this.badgeService.findEnabledBadgesByDomain(domain);
            BadgeDTO badgeDTO2 = null;
            JSONObject reputation = null;
            int index = 0;
            for (BadgeDTO badgeDTO2 : allBadges) {
                if ((long)badgeDTO2.getNeededScore() >= score) continue;
                ++index;
            }
            if (index > 0) {
                badgeDTO2 = allBadges.get(index - 1);
                reputation = new JSONObject();
                String iconUrl = "/rest/gamification/reputation/badge/" + badgeDTO2.getTitle() + "/avatar";
                reputation.put("url", (Object)iconUrl);
                reputation.put("description", (Object)badgeDTO2.getDescription());
                reputation.put("id", (Object)badgeDTO2.getId());
                reputation.put("title", (Object)badgeDTO2.getTitle());
                reputation.put("zone", (Object)badgeDTO2.getDomain());
                reputation.put("level", index);
                reputation.put("startScore", badgeDTO2.getNeededScore());
                reputation.put("endScore", (Object)this.computeBadgeNextLevel(allBadges, index));
                userBadges.put((Object)reputation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String computeBadgeNextLevel(List<BadgeDTO> allBadges, int index) {
        if (index >= 0 && index < allBadges.size()) {
            return String.valueOf(allBadges.get(index).getNeededScore());
        }
        return "";
    }
}

