/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.task;

import java.time.LocalDate;
import java.util.Iterator;
import java.util.Set;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.listener.GamificationListener;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.effective.GamificationProcessor;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.service.TaskPayload;
import org.exoplatform.task.service.TaskService;

public class GamificationTaskUpdateListener
extends Listener<TaskService, TaskPayload>
implements GamificationListener {
    protected RuleService ruleService;
    protected GamificationProcessor gamificationProcessor;
    protected IdentityManager identityManager;
    protected GamificationService gamificationService;

    public GamificationTaskUpdateListener(RuleService ruleService, GamificationProcessor gamificationProcessor, IdentityManager identityManager, GamificationService gamificationService) {
        this.ruleService = ruleService;
        this.gamificationProcessor = gamificationProcessor;
        this.identityManager = identityManager;
        this.gamificationService = gamificationService;
    }

    public void onEvent(Event<TaskService, TaskPayload> event) throws Exception {
        TaskPayload data = (TaskPayload)event.getData();
        Task oldTask = data.before();
        Task newTask = data.after();
        if (oldTask == null && newTask != null) {
            this.createTask("created");
        }
        if (oldTask != null && newTask != null) {
            this.updateTask(oldTask, newTask);
        }
    }

    protected void createTask(String actionName) {
        String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
        GamificationActionsHistory aHistory = null;
        String actorId = this.identityManager.getOrCreateIdentity("organization", actorUsername, false).getId();
        RuleDTO ruleDto = this.ruleService.findEnableRuleByTitle("createNewTask");
        if (ruleDto != null) {
            try {
                aHistory = this.build(ruleDto, actorId);
                this.gamificationProcessor.execute(aHistory);
                LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), actorId, aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
            }
            catch (Exception e) {
                LOG.error("Error processing the following ActionHistory entry {}", new Object[]{aHistory, e});
            }
        }
    }

    protected void updateTask(Task before, Task after) {
        block11: {
            GamificationActionsHistory aHistory;
            String actorId;
            RuleDTO ruleDto;
            block10: {
                Set cowrokers;
                ruleDto = null;
                actorId = "";
                aHistory = null;
                if (!this.isDiff(before.isCompleted(), after.isCompleted())) break block10;
                if (after.getAssignee() != null && after.getAssignee().length() != 0) {
                    actorId = this.identityManager.getOrCreateIdentity("organization", after.getAssignee(), false).getId();
                    ruleDto = this.ruleService.findEnableRuleByTitle("completeTaskAssigned");
                    if (ruleDto != null) {
                        try {
                            aHistory = this.build(ruleDto, actorId);
                            this.gamificationProcessor.execute(aHistory);
                            LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), actorId, aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                        }
                        catch (Exception e) {
                            LOG.error("Error processing the following ActionHistory entry {}", new Object[]{aHistory, e});
                        }
                    }
                }
                if ((cowrokers = after.getCoworker()) == null) {
                    return;
                }
                ruleDto = this.ruleService.findEnableRuleByTitle("completeTaskCoworker");
                Iterator coworker = cowrokers.iterator();
                while (coworker.hasNext()) {
                    actorId = this.identityManager.getOrCreateIdentity("organization", (String)coworker.next(), false).getId();
                    if (ruleDto == null) continue;
                    try {
                        aHistory = this.build(ruleDto, actorId);
                        this.gamificationProcessor.execute(aHistory);
                        LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), actorId, aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                    }
                    catch (Exception e) {
                        LOG.error("Error processing the following ActionHistory entry {}", new Object[]{aHistory, e});
                    }
                }
                break block11;
            }
            String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
            actorId = this.identityManager.getOrCreateIdentity("organization", actorUsername, false).getId();
            ruleDto = this.ruleService.findEnableRuleByTitle("updateTask");
            if (ruleDto == null) break block11;
            try {
                aHistory = this.build(ruleDto, actorId);
                LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), actorId, aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                this.gamificationProcessor.execute(aHistory);
            }
            catch (Exception e) {
                LOG.error("Error processing the following ActionHistory entry {}", new Object[]{aHistory, e});
            }
        }
    }

    protected boolean isDiff(Object before, Object after) {
        if (before == after) {
            return false;
        }
        if (before != null) {
            return !before.equals(after);
        }
        return !after.equals(before);
    }
}

