/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.forum;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ForumUtils {
    protected static Log log = ExoLogger.getLogger(ForumUtils.class);
    public static final String POST = "post".intern();
    public static final String TAG = "Tag".intern();
    public static final String SLASH = "/".intern();
    public static final String EMPTY_STR = "".intern();

    private static String buildForumLink(String url, String type, String id) {
        StringBuilder link = new StringBuilder(url);
        if (!ForumUtils.isEmpty(type) && !ForumUtils.isEmpty(id)) {
            if (link.lastIndexOf(SLASH) == link.length() - 1) {
                link.append(type);
            } else {
                link.append(SLASH).append(type);
            }
            if (!id.equals(Utils.FORUM_SERVICE)) {
                link.append(SLASH).append(id);
            }
        }
        return link.toString();
    }

    public static String createdForumLink(String type, String id, boolean isPrivate) {
        try {
            PortalRequestContext portalContext = Util.getPortalRequestContext();
            String fullUrl = portalContext.getRequest().getRequestURL().toString();
            String host = fullUrl.substring(0, fullUrl.indexOf(SLASH, 8));
            return new StringBuffer(host).append(ForumUtils.createdSubForumLink(type, id, isPrivate)).toString();
        }
        catch (Exception e) {
            return id;
        }
    }

    public static String createdSubForumLink(String type, String id, boolean isPrivate) {
        try {
            String containerName = ((ExoContainerContext)CommonsUtils.getService(ExoContainerContext.class)).getPortalContainerName();
            String pageNodeSelected = Util.getUIPortal().getSelectedUserNode().getURI();
            PortalRequestContext portalContext = Util.getPortalRequestContext();
            return ForumUtils.buildLink(portalContext.getPortalURI(), containerName, pageNodeSelected, type, id, isPrivate);
        }
        catch (Exception e) {
            return id;
        }
    }

    public static String buildLink(String portalURI, String containerName, String selectedNode, String type, String id, boolean isPrivate) {
        StringBuilder sb = new StringBuilder();
        portalURI = portalURI.concat(selectedNode).concat(SLASH);
        if (!isPrivate) {
            sb.append(ForumUtils.buildForumLink(portalURI, type, id));
        } else {
            String host = portalURI.substring(0, portalURI.indexOf(containerName) - 1);
            sb.append(host).append(SLASH).append(containerName).append(SLASH).append("login?&initialURI=").append(ForumUtils.buildForumLink(portalURI.replaceFirst(host, EMPTY_STR), type, id)).toString();
        }
        return sb.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isArrayEmpty(String[] strs) {
        return strs == null || strs.length == 0 || strs.length == 1 && strs[0].trim().length() <= 0;
    }
}

