/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.entities.domain.configuration;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.exoplatform.addons.gamification.entities.domain.configuration.AbstractAuditingEntity;
import org.exoplatform.addons.gamification.entities.domain.configuration.DomainEntity;
import org.exoplatform.commons.api.persistence.ExoEntity;

@Entity(name="Rule")
@ExoEntity
@Table(name="GAMIFICATION_RULE")
@NamedQueries(value={@NamedQuery(name="Rule.getAllRules", query="SELECT rule FROM Rule rule WHERE rule.isDeleted = false"), @NamedQuery(name="Rule.getEnabledRules", query="SELECT rule FROM Rule rule where rule.isEnabled = :isEnabled AND rule.isDeleted = false"), @NamedQuery(name="Rule.getAllRulesByDomain", query="SELECT rule FROM Rule rule where rule.area = :domain AND rule.isDeleted = false"), @NamedQuery(name="Rule.getAllRulesWithNullDomain", query="SELECT rule FROM Rule rule where rule.domainEntity IS NULL "), @NamedQuery(name="Rule.findEnabledRuleByTitle", query="SELECT rule FROM Rule rule where rule.title = :ruleTitle and rule.isEnabled = true"), @NamedQuery(name="Rule.findEnabledRulesByEvent", query="SELECT rule FROM Rule rule where rule.event = :event and rule.isEnabled = true AND rule.isDeleted = false"), @NamedQuery(name="Rule.findRuleByTitle", query="SELECT rule FROM Rule rule where rule.title = :ruleTitle"), @NamedQuery(name="Rule.getDomainList", query="SELECT rule.area  FROM Rule rule GROUP BY rule.area"), @NamedQuery(name="Rule.getEventList", query="SELECT rule.event  FROM Rule rule  GROUP BY rule.event"), @NamedQuery(name="Rule.deleteRuleByTitle", query="DELETE FROM Rule rule WHERE rule.title = :ruleTitle "), @NamedQuery(name="Rule.deleteRuleById", query="DELETE FROM Rule rule WHERE rule.id = :ruleId ")})
public class RuleEntity
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    protected Long id;
    @Column(name="TITLE", unique=true, nullable=false)
    protected String title;
    @Column(name="DESCRIPTION")
    protected String description;
    @Column(name="SCORE")
    protected int score;
    @Column(name="AREA", unique=false, nullable=false)
    protected String area;
    @Column(name="EVENT", unique=false, nullable=false)
    protected String event;
    @ManyToOne
    @JoinColumn(name="DOMAIN_ID")
    private DomainEntity domainEntity;
    @Column(name="ENABLED", nullable=false)
    protected boolean isEnabled;
    @Column(name="DELETED", nullable=false)
    protected boolean isDeleted;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public DomainEntity getDomainEntity() {
        return this.domainEntity;
    }

    public void setDomainEntity(DomainEntity domainEntity) {
        this.domainEntity = domainEntity;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean deleted) {
        this.isDeleted = deleted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleEntity ruleEntity = (RuleEntity)o;
        return ruleEntity.getId() != null && this.getId() != null && Objects.equals(this.getId(), ruleEntity.getId());
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    public String toString() {
        return "Badge{title='" + this.title + '\'' + ", score='" + this.score + '\'' + ", area='" + this.area + '\'' + ", description='" + this.description + '\'' + ", enable='" + this.isEnabled + '\'' + "}";
    }
}

