/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.social.activity;

import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;

@Asynchronous
public class GamificationActivityListener
extends ActivityListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(GamificationActivityListener.class);
    protected RuleService ruleService = (RuleService)CommonsUtils.getService(RuleService.class);
    protected IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
    protected SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
    protected GamificationService gamificationService = (GamificationService)CommonsUtils.getService(GamificationService.class);
    protected ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);

    public void saveActivity(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        Object aHistory = null;
        Object ruleDto = null;
        if (!activity.getType().equals("SPACE_ACTIVITY") && (activity.getType().equalsIgnoreCase("files:spaces") || activity.getType().equalsIgnoreCase("DOC_ACTIVITY") || activity.getType().equalsIgnoreCase("contents:spaces"))) {
            this.gamificationService.createHistory("uploaddocumentOnNetworkStream", activity.getPosterId(), activity.getPosterId(), "/portal/intranet/activity?id=" + activity.getId());
        }
        if (this.isSpaceActivity(activity)) {
            if (!activity.getType().equals("SPACE_ACTIVITY")) {
                this.gamificationService.createHistory("addActivityOnSpaceStream", activity.getPosterId(), activity.getPosterId(), "/portal/intranet/activity?id=" + activity.getId());
                String spaceManager = this.spaceService.getSpaceByPrettyName(this.identityManager.getIdentity(activity.getStreamId(), false).getRemoteId()).getManagers()[0];
                this.gamificationService.createHistory("addActivityOnSpaceStreamTarget", activity.getPosterId(), spaceManager, "/portal/intranet/activity?id=" + activity.getId());
            }
        } else if (activity.getPosterId().equalsIgnoreCase(activity.getStreamId())) {
            this.gamificationService.createHistory("addActivityOnMyStream", activity.getPosterId(), activity.getStreamId(), "/portal/intranet/activity?id=" + activity.getId());
        } else {
            this.gamificationService.createHistory("addActivityTargetUserStream", activity.getPosterId(), activity.getStreamId(), "/portal/intranet/activity?id=" + activity.getId());
            this.gamificationService.createHistory("addActivityOnNetworkStream", activity.getPosterId(), activity.getStreamId(), "/portal/intranet/activity?id=" + activity.getId());
            if (!activity.getType().equalsIgnoreCase("DOC_ACTIVITY")) {
                return;
            }
        }
    }

    public void updateActivity(ActivityLifeCycleEvent event) {
    }

    public void saveComment(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        Object aHistory = null;
        Object ruleDto = null;
        ExoSocialActivity parent = this.activityManager.getParentActivity(activity);
        if (activity.getPosterId().equalsIgnoreCase(activity.getStreamId())) {
            return;
        }
        if (parent != null && !parent.getType().equals("SPACE_ACTIVITY")) {
            this.gamificationService.createHistory("commentOnNetworkStream", activity.getPosterId(), parent.getPosterId(), "/portal/intranet/activity?id=" + parent.getId() + "#comment-" + ((ExoSocialActivityImpl)activity).getId());
            this.gamificationService.createHistory("addComment", activity.getPosterId(), activity.getPosterId(), "/portal/intranet/activity?id=" + parent.getId() + "#comment-" + ((ExoSocialActivityImpl)activity).getId());
        }
    }

    public void updateComment(ActivityLifeCycleEvent activityLifeCycleEvent) {
    }

    public void likeActivity(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        Object aHistory = null;
        Object ruleDto = null;
        if (this.isSpaceActivity(activity)) {
            String[] likersId = activity.getLikeIdentityIds();
            String liker = this.identityManager.getIdentity(likersId[likersId.length - 1], false).getId();
            this.gamificationService.createHistory("likeActivityOnSpaceStream", activity.getPosterId(), liker, "/portal/intranet/activity?id=" + activity.getId() + "#comment-" + ((ExoSocialActivityImpl)activity).getId());
            this.gamificationService.createHistory("likeActivityOnSpaceStreamTarget", liker, activity.getPosterId(), "/portal/intranet/activity?id=" + activity.getId());
        } else {
            String[] likersId = activity.getLikeIdentityIds();
            String liker = this.identityManager.getIdentity(likersId[likersId.length - 1], false).getId();
            if (activity.getPosterId().equalsIgnoreCase(liker)) {
                return;
            }
            this.gamificationService.createHistory("likeActivityOnNetworkStream", activity.getPosterId(), liker, "/portal/intranet/activity?id=" + activity.getId() + "#comment-" + ((ExoSocialActivityImpl)activity).getId());
            this.gamificationService.createHistory("likeActivityTargetUserStream", liker, activity.getPosterId(), "/portal/intranet/activity?id=" + activity.getId() + "#comment-" + ((ExoSocialActivityImpl)activity).getId());
        }
    }

    public void likeComment(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        String[] likersId = activity.getLikeIdentityIds();
        String liker = this.identityManager.getIdentity(likersId[likersId.length - 1], false).getId();
        Object aHistory = null;
        Object ruleDto = null;
        if (this.isSpaceActivity(activity)) {
            this.gamificationService.createHistory("likeCommentOnspaceStream", liker, activity.getPosterId(), "/portal/intranet/activity?id=" + activity.getParentId() + "#comment-" + ((ExoSocialActivityImpl)activity).getId());
        } else {
            if (activity.getPosterId().equalsIgnoreCase(activity.getStreamId())) {
                return;
            }
            this.gamificationService.createHistory("likeCommentOnNetworkStream", activity.getPosterId(), liker, "/portal/intranet/activity?id=" + activity.getParentId() + "#comment-" + ((ExoSocialActivityImpl)activity).getId());
        }
        this.gamificationService.createHistory("likeComment", liker, activity.getPosterId(), "/portal/intranet/activity?id=" + activity.getParentId() + "#comment-" + ((ExoSocialActivityImpl)activity).getId());
    }

    public boolean isSpaceActivity(ExoSocialActivity activity) {
        Identity id = this.identityManager.getOrCreateIdentity("space", activity.getStreamOwner(), false);
        return id != null;
    }
}

