/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.setting.zone.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.addons.gamification.service.configuration.DomainService;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO;
import org.exoplatform.addons.gamification.service.setting.zone.ZoneRegistry;
import org.exoplatform.addons.gamification.service.setting.zone.model.ZoneConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class ZoneRegistryImpl
implements Startable,
ZoneRegistry {
    private static final Log LOG = ExoLogger.getLogger(ZoneRegistryImpl.class);
    private static final String GAMIFICATION_PREFERENCES = "gamification:";
    private final Map<String, ZoneConfig> zoneMap = new HashMap<String, ZoneConfig>();
    private DomainService domainService;

    public ZoneRegistryImpl(DomainService domainService) {
        this.domainService = domainService;
    }

    @Override
    public void addPlugin(ZoneConfig zone) {
        this.zoneMap.put(zone.getZoneName(), zone);
    }

    @Override
    public boolean remove(ZoneConfig zone) {
        return false;
    }

    public void start() {
        try {
            for (ZoneConfig domain : this.zoneMap.values()) {
                DomainDTO domainDTO = this.domainService.findDomainByTitle(domain.getZoneName());
                if (domainDTO != null) continue;
                this.store(domain);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error when processing Domains ", (Throwable)e);
        }
    }

    public void stop() {
    }

    private void store(ZoneConfig zoneConfig) {
        DomainDTO domainDTO = new DomainDTO();
        domainDTO.setTitle(zoneConfig.getZoneName());
        domainDTO.setDescription(zoneConfig.getZoneDescription());
        domainDTO.setLastModifiedDate(new Date());
        domainDTO.setLastModifiedBy("Gamification");
        domainDTO.setEnabled(true);
        domainDTO.setDeleted(false);
        domainDTO.setCreatedBy("Gamification");
        domainDTO.setCreatedDate(new Date());
        try {
            domainDTO.setPriority(Integer.parseInt(zoneConfig.getZonePriority()));
        }
        catch (Exception e) {
            domainDTO.setPriority(10);
        }
        this.domainService.addDomain(domainDTO);
    }
}

