/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage;

import java.util.Date;
import java.util.List;
import org.exoplatform.addons.gamification.entities.domain.configuration.DomainEntity;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO;
import org.exoplatform.addons.gamification.service.mapper.DomainMapper;
import org.exoplatform.addons.gamification.storage.dao.DomainDAO;

public class DomainStorage {
    private DomainDAO domainDAO;

    public DomainStorage(DomainDAO domainDAO) {
        this.domainDAO = domainDAO;
    }

    public DomainDTO saveDomain(DomainDTO domainDTO) {
        DomainEntity domainEntity = DomainMapper.domainDTOToDomain(domainDTO);
        if (domainEntity.getId() == null || domainEntity.getId() == 0L) {
            domainEntity.setCreatedDate(new Date());
            domainEntity.setLastModifiedDate(new Date());
            domainEntity = (DomainEntity)this.domainDAO.create(domainEntity);
        } else {
            domainEntity.setLastModifiedDate(new Date());
            domainEntity = (DomainEntity)this.domainDAO.update(domainEntity);
        }
        return DomainMapper.domainToDomainDTO(domainEntity);
    }

    public DomainDTO findDomainByTitle(String domainTitle) {
        return DomainMapper.domainEntityToDomainDTO(this.domainDAO.findDomainByTitle(domainTitle));
    }

    public List<DomainDTO> getAllDomains() {
        return DomainMapper.domainssToDomainDTOs(this.domainDAO.getAllDomains());
    }

    public List<DomainDTO> getEnabledDomains() {
        return DomainMapper.domainssToDomainDTOs(this.domainDAO.getEnabledDomains());
    }

    public DomainDTO getDomainByID(Long id) {
        return DomainMapper.domainEntityToDomainDTO((DomainEntity)this.domainDAO.find(id));
    }

    public int deleteDomainByTitle(String domainTitle) {
        return this.domainDAO.deleteDomainByTitle(domainTitle);
    }
}

